package eu.dnetlib.data.mapreduce.hbase.dataimport;

import java.util.Properties;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;

public class HTableImportJob extends AbstractHBaseMapReduceJob {

	@Override
	protected Job setJobDetails(Job job, Properties p) throws Exception {
		job.setMapOutputKeyClass(ImmutableBytesWritable.class);
		job.setMapOutputValueClass(Put.class);
		job.setMapperClass(SequenceFileRecordMapper.class);

		job.setInputFormatClass(SequenceFileInputFormat.class);
		job.setOutputFormatClass(TableOutputFormat.class);

		SequenceFileInputFormat.setInputPaths(job, p.getProperty(JobParams.MAPRED_INPUT_DIR));

		job.setNumReduceTasks(0);

		return job;
	}

}
