package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;

import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

import com.google.common.collect.Lists;
import com.google.gson.Gson;

import eu.dnetlib.data.mapreduce.hbase.HBaseTableUtils.VolatileColumnFamily;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;

public class FindPersonCoauthorsMapper extends TableMapper<Text, Text> {
	private final HttpClient client = new DefaultHttpClient();

	private final String url = "http://146.48.87.97:8888/addData";

	@Override
	protected void setup(Context context) {
		//		url = context.getConfiguration().get("dedup.person.coauthors.service.url");
	}

	@Override
	protected void map(ImmutableBytesWritable rowkey, Result row, Context context) throws IOException, InterruptedException {
		NavigableMap<byte[], byte[]> candidates = row.getFamilyMap(Bytes.toBytes(VolatileColumnFamily.dedupPerson.toString()));
		if (candidates == null || candidates.isEmpty()) {
			return;
		}

		List<String> coauthors = Lists.newArrayList();
		for (byte[] b : row.getFamilyMap(Bytes.toBytes(RelType.personResult.toString())).keySet()) {
			coauthors.add(Bytes.toString(b));
		}

		for (byte[] candidate : candidates.keySet()) {
			emit(context, Bytes.toString(candidate), coauthors);
		}
	}

	private void emit(Context context, String candidate, List<String> coauthors) {
		try {
			HttpUriRequest request = new HttpPost(url);
			HttpParams params = new BasicHttpParams();
			params.setParameter("id", candidate);
			params.setParameter("data", (new Gson().toJson(coauthors)));
			request.setParams(params);
			HttpResponse response = client.execute(request);
			context.getCounter("HTTP call", "code " + response.getStatusLine().getStatusCode()).increment(1);
		} catch (Exception e) {
			context.getCounter("HTTP call", "Exception " + e.getClass()).increment(1);
		}
	}
}
