package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.util.Set;

import com.google.gson.Gson;

import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class LinkDescriptor {

	private RelDescriptor relDescriptor;
	private Type target;
	private boolean isChild = false;
	private Set<String> fields;
	private boolean symmetric = true;

	public LinkDescriptor(RelDescriptor relDescriptor, Type target, boolean isChild, boolean symmetric, Set<String> fields) {
		super();
		this.setRelDescriptor(relDescriptor);
		this.setTarget(target);
		this.setChild(isChild);
		this.setFields(fields);
		this.setSymmetric(symmetric);
	}

	public LinkDescriptor(RelDescriptor relDescriptor, Type target) {
		super();
		this.setRelDescriptor(relDescriptor);
		this.setTarget(target);
	}

	public Type getTarget() {
		return target;
	}

	public boolean isChild() {
		return isChild;
	}

	public void setTarget(Type target) {
		this.target = target;
	}

	public void setChild(boolean isChild) {
		this.isChild = isChild;
	}

	public Set<String> getFields() {
		return fields;
	}

	public void setFields(Set<String> fields) {
		this.fields = fields;
	}

	public boolean isSymmetric() {
		return symmetric;
	}

	public void setSymmetric(boolean symmetric) {
		this.symmetric = symmetric;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

	public RelDescriptor getRelDescriptor() {
		return relDescriptor;
	}

	public void setRelDescriptor(RelDescriptor relDescriptor) {
		this.relDescriptor = relDescriptor;
	}

}
