/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.index.config.RelClasses;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafEntityMerger;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.mapreduce.util.OafUtils;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupBuildRootsReducer
extends TableReducer<Text, ImmutableBytesWritable, ImmutableBytesWritable> {
    private static final boolean WRITE_TO_WAL = false;
    private DedupConfig dedupConf;
    private RelClasses relClasses;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.dedupConf = DedupConfigLoader.load((String)context.getConfiguration().get("dedup.wf.conf"));
        System.out.println("dedup buildRoots reducer\n\nwf conf: " + this.dedupConf.toString());
        String relClassJson = context.getConfiguration().get("relClasses");
        System.out.println("relClassesJson:\n" + relClassJson);
        this.relClasses = RelClasses.fromJSon(relClassJson);
        System.out.println("relClasses:\n" + this.relClasses);
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (!DedupUtils.isRoot(key.toString())) {
            System.err.println("aborting DedupBuildRootsReducer, found non-root key: " + key);
            context.getCounter("DedupBuildRootsReducer", "aborted").increment(1L);
            return;
        }
        byte[] rowkey = Bytes.toBytes((String)key.toString());
        ArrayList entities = Lists.newArrayList();
        for (OafProtos.Oaf oaf : this.toOaf(values)) {
            switch (oaf.getKind()) {
                case entity: {
                    entities.add(oaf);
                    break;
                }
                case relation: {
                    this.handleRels(context, rowkey, oaf, true);
                    break;
                }
            }
        }
        OafProtos.Oaf.Builder builder = new OafEntityMerger().mergeEntities(key.toString(), entities);
        if (entities.size() < 20) {
            context.getCounter(this.dedupConf.getEntityType() + " root group size", this.lpad(entities.size())).increment(1L);
        } else {
            context.getCounter(this.dedupConf.getEntityType() + " root group size", "> 20").increment(1L);
        }
        this.emit(context, rowkey, this.dedupConf.getEntityType(), "body", builder.build().toByteArray(), "root");
    }

    private Iterable<OafProtos.Oaf> toOaf(Iterable<ImmutableBytesWritable> values) {
        return Iterables.transform(values, OafUtils.oafDecoder());
    }

    private void handleRels(Reducer.Context context, byte[] rowkey, OafProtos.Oaf oaf, boolean hack) throws IOException, InterruptedException, InvalidProtocolBufferException {
        byte[] revKey;
        OafDecoder decoder;
        if (hack && this.checkHack(new String(rowkey), oaf)) {
            context.getCounter("hack", "personResult in").increment(1L);
        } else {
            decoder = this.rootToEntity(rowkey, oaf);
            this.emit(context, rowkey, decoder.getCFQ(), decoder.relTargetId(), decoder.toByteArray(), "[root -> entity]");
            decoder = this.entityToRoot(rowkey, oaf);
            revKey = Bytes.toBytes((String)decoder.relSourceId());
            this.emit(context, revKey, decoder.getCFQ(), new String(rowkey), decoder.toByteArray(), "[entity -> root]");
        }
        decoder = this.markDeleted(oaf, true);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        this.emit(context, revKey, decoder.getCFQ(), decoder.relTargetId(), decoder.toByteArray(), "mark deleted [dup -> entity]");
        decoder = this.markDeleted(oaf, false);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        this.emit(context, revKey, decoder.getCFQ(), decoder.relTargetId(), decoder.toByteArray(), "mark deleted [entity -> dup]");
    }

    private void emit(Reducer.Context context, byte[] rowkey, String family, String qualifier, byte[] value, String label) throws IOException, InterruptedException {
        Put put = new Put(rowkey).add(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier), value);
        put.setWriteToWAL(false);
        context.write((Object)new ImmutableBytesWritable(rowkey), (Object)put);
        context.getCounter(family, label).increment(1L);
    }

    public boolean checkHack(String root, OafProtos.Oaf oaf) {
        boolean res = this.dedupConf.getEntityType().equals(TypeProtos.Type.result.toString()) && oaf.getRel().getRelType().toString().equals(RelTypeProtos.RelType.personResult.toString()) && !this.md5matches(root, oaf.getRel().getSource());
        return res;
    }

    private boolean md5matches(String id1, String id2) {
        return id1.replaceAll("^.*\\:\\:", "").equals(id2.replaceAll("^.*\\:\\:", ""));
    }

    private OafDecoder rootToEntity(byte[] rootRowkey, OafProtos.Oaf rel) {
        return this.patchRelations(rootRowkey, rel, OafPatch.rootToEntity);
    }

    private OafDecoder entityToRoot(byte[] rootRowkey, OafProtos.Oaf rel) {
        return this.patchRelations(rootRowkey, rel, OafPatch.entityToRoot);
    }

    private OafDecoder markDeleted(OafProtos.Oaf rel, boolean reverse) {
        return this.deleteRelations(rel, reverse);
    }

    private OafDecoder patchRelations(byte[] rootRowkey, OafProtos.Oaf rel, OafPatch patchKind) {
        OafRelDecoder decoder = OafRelDecoder.decode((OafProtos.OafRel)rel.getRel());
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel);
        builder.getDataInfoBuilder().setInferred(true).setDeletedbyinference(false);
        switch (patchKind) {
            case rootToEntity: {
                builder.getRelBuilder().setSource(new String(rootRowkey));
                break;
            }
            case entityToRoot: {
                builder.setRel(decoder.setClassId(this.relClasses.getInverse(rel.getRel().getRelClass())));
                builder.getRelBuilder().setSource(builder.getRel().getTarget());
                builder.getRelBuilder().setTarget(new String(rootRowkey));
                break;
            }
        }
        return OafDecoder.decode((OafProtos.Oaf)builder.build());
    }

    private OafDecoder deleteRelations(OafProtos.Oaf rel, boolean reverse) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel);
        builder.getDataInfoBuilder().setDeletedbyinference(true);
        if (reverse) {
            OafRelDecoder decoder = OafRelDecoder.decode((OafProtos.OafRel)rel.getRel());
            builder.setRel(decoder.setClassId(this.relClasses.getInverse(rel.getRel().getRelClass())));
            String tmp = builder.getRel().getSource();
            builder.getRelBuilder().setSource(builder.getRel().getTarget());
            builder.getRelBuilder().setTarget(tmp);
        }
        return OafDecoder.decode((OafProtos.Oaf)builder.build());
    }

    private String lpad(int s) {
        return StringUtils.leftPad((String)String.valueOf(s), (int)5);
    }

    private static enum OafPatch {
        rootToEntity,
        entityToRoot;

    }
}

