/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.IndexConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.hbase.index.config.RelClasses;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class PrepareFeedMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private EntityConfigTable entityConfigTable;
    private RelClasses relClasses;
    private Text outKey;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String json = context.getConfiguration().get("index.entity.links");
        System.out.println("index.entity.links:\n" + json);
        this.entityConfigTable = IndexConfig.load(json).getConfigMap();
        String contextMap = context.getConfiguration().get("contextmap");
        System.out.println("contextmap:\n" + contextMap);
        String relClassJson = context.getConfiguration().get("relClasses");
        System.out.println("relClassesJson:\n" + relClassJson);
        this.relClasses = RelClasses.fromJSon(relClassJson);
        System.out.println("relClasses:\n" + this.relClasses);
        this.outKey = new Text();
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes());
        TypeProtos.Type type = keyDecoder.getType();
        OafProtos.Oaf oaf = this.mergeUpdates(value, context, type, keyDecoder);
        if (this.isValid(oaf)) {
            if (!this.deletedByInference(oaf) || this.entityConfigTable.includeDuplicates(type)) {
                this.emit(new String(keyIn.copyBytes()), context, oaf);
                this.incrementCounter(context, KindProtos.Kind.entity.toString(), type.toString(), 1);
                for (LinkDescriptor ld : this.entityConfigTable.getDescriptors(type)) {
                    NavigableMap columnMap = value.getFamilyMap(Bytes.toBytes((String)ld.getRelDescriptor().getIt()));
                    if (!this.hasData(columnMap)) continue;
                    this.emitRelationship(oaf.getEntity(), context, columnMap, ld);
                    this.incrementCounter(context, type.toString(), ld.getRelDescriptor().getIt(), columnMap.size());
                }
            } else {
                this.incrementCounter(context, "deleted by inference", type.toString(), 1);
            }
        } else {
            this.incrementCounter(context, "missing body", type.toString(), 1);
        }
    }

    private OafProtos.Oaf mergeUpdates(Result value, Mapper.Context context, TypeProtos.Type type, OafRowKeyDecoder keyDecoder) throws InvalidProtocolBufferException {
        try {
            return UpdateMerger.mergeBodyUpdates(context, value.getFamilyMap(Bytes.toBytes((String)type.toString())));
        }
        catch (InvalidProtocolBufferException e) {
            System.err.println(String.format("Unable to parse proto (Type: %s) in row: %s", type.toString(), keyDecoder.getKey()));
            throw e;
        }
    }

    private void emitRelationship(OafProtos.OafEntity cachedTarget, Mapper.Context context, Map<byte[], byte[]> columnMap, LinkDescriptor ld) throws IOException, InterruptedException {
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation);
        for (Map.Entry<byte[], byte[]> e : columnMap.entrySet()) {
            OafProtos.Oaf oaf = this.decodeProto(context, e.getValue());
            if (!this.isValid(oaf)) {
                this.incrementCounter(context, "invalid oaf rel", ld.getRelDescriptor().getIt(), 1);
                continue;
            }
            if (!this.deletedByInference(oaf)) {
                OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder((OafProtos.OafRel)oaf.getRel());
                if (ld.isSymmetric()) {
                    RelDescriptor rd = ld.getRelDescriptor();
                    relBuilder.setCachedTarget(cachedTarget).setRelType(rd.getRelType()).setSubRelType(rd.getSubRelType());
                }
                if (ld.getRelDescriptor().getIt().contains(RelTypeProtos.SubRelType.dedup.toString()) && this.isDedupSelf((OafProtos.OafRelOrBuilder)relBuilder)) {
                    this.incrementCounter(context, "avoid to emit dedup self", ld.getRelDescriptor().getIt(), 1);
                    continue;
                }
                OafProtos.OafRel oafRel = relBuilder.setChild(ld.isChild()).build();
                this.emit(ld.isSymmetric() ? oafRel.getTarget() : oafRel.getSource(), context, this.merge(oafBuilder, oaf).setRel(oafRel).build());
                continue;
            }
            this.incrementCounter(context, "deleted by inference", ld.getRelDescriptor().getIt(), 1);
        }
    }

    private String patchTargetId(TypeProtos.Type target, String id) {
        return id.replaceFirst("^.*\\|", target.getNumber() + "|");
    }

    private OafProtos.Oaf.Builder merge(OafProtos.Oaf.Builder builder, OafProtos.Oaf prototype) {
        return builder.setDataInfo(prototype.getDataInfo()).setTimestamp(prototype.getTimestamp());
    }

    private boolean isDedupSelf(OafProtos.OafRelOrBuilder rel) {
        return rel.getSource().contains(rel.getTarget());
    }

    private boolean hasData(Map<byte[], byte[]> columnMap) {
        return columnMap != null && !columnMap.isEmpty();
    }

    private boolean isValid(OafProtos.Oaf oaf) {
        return oaf != null && oaf.isInitialized();
    }

    private boolean deletedByInference(OafProtos.Oaf oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private OafProtos.Oaf decodeProto(Mapper.Context context, byte[] body) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])body);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace(System.err);
            context.getCounter("decodeProto", ((Object)((Object)e)).getClass().getName()).increment(1L);
            return null;
        }
    }

    private void emit(String key, Mapper.Context context, OafProtos.Oaf oaf) throws IOException, InterruptedException {
        this.outKey.set(key);
        this.ibw.set(oaf.toByteArray());
        context.write((Object)this.outKey, (Object)this.ibw);
    }

    private void incrementCounter(Mapper.Context context, String k, String t, int n) {
        this.getCounter(context, k, t).increment((long)n);
    }

    private Counter getCounter(Mapper.Context context, String k, String t) {
        return context.getCounter(k, t);
    }
}

