/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.stats;

import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class StatsFeedMapper
extends Mapper<Text, Text, Text, Text> {
    private List<String> buffer;
    private int bufferFlushThreshold = 1000;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.buffer = Lists.newArrayList();
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String copyCmd = this.buildCopyCommand(value);
        try {
            if (copyCmd != null && !copyCmd.isEmpty()) {
                this.buffer.add(copyCmd);
                if (this.buffer.size() >= this.bufferFlushThreshold) {
                    this.doAdd(this.buffer, context);
                }
            } else {
                context.getCounter("stats", "skipped records").increment(1L);
            }
        }
        catch (Throwable e) {
            context.getCounter("stats", e.getClass().toString()).increment(1L);
            context.write((Object)key, (Object)this.printRottenRecord(context.getTaskAttemptID().toString(), value, copyCmd));
            e.printStackTrace(System.err);
        }
    }

    private String buildCopyCommand(Text value) {
        return null;
    }

    private void doAdd(List<String> buffer, Mapper.Context context) {
        long start = System.currentTimeMillis();
        long stop = System.currentTimeMillis() - start;
        System.out.println("feed time for " + buffer.size() + " records : " + HumanTime.exactly((long)stop) + "\n");
        buffer.clear();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        if (!this.buffer.isEmpty()) {
            this.doAdd(this.buffer, context);
        }
    }

    private Text printRottenRecord(String taskid, Text value, String copyCmq) {
        return new Text("\n**********************************\ntask: " + taskid + "\n" + this.check("original", value.toString() + this.check("copy cmd", copyCmq)));
    }

    private String check(String label, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            return "\n " + label + ":\n" + value + "\n";
        }
        return "\n";
    }
}

