package eu.dnetlib.data.mapreduce.util;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

import com.google.common.base.Function;
import com.google.protobuf.InvalidProtocolBufferException;

import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.transform.OafUtils;

public class OafHbaseUtils extends OafUtils {

	public static OafDecoder decode(final ImmutableBytesWritable oaf) {
		return new OafDecoder(oaf.copyBytes());
	}

	public static Function<ImmutableBytesWritable, OafDecoder> decoder() {
		return new Function<ImmutableBytesWritable, OafDecoder>() {

			@Override
			public OafDecoder apply(final ImmutableBytesWritable input) {
				return OafDecoder.decode(input.copyBytes());
			}
		};
	}

	public static Function<ImmutableBytesWritable, Oaf> oafDecoder() {
		return new Function<ImmutableBytesWritable, Oaf>() {

			@Override
			public Oaf apply(final ImmutableBytesWritable input) {
				return parse(input);
			}
		};
	}

	public static Oaf parse(final ImmutableBytesWritable input) {
		try {
			return Oaf.parseFrom(input.copyBytes());
		} catch (final InvalidProtocolBufferException e) {
			throw new IllegalArgumentException(e);
		}
	}

}
