package eu.dnetlib.data.mapreduce.hbase.actions;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;

public class CommitActionsJob extends AbstractActionsJob {

	@Override
	protected Class<? extends TableMapper<ImmutableBytesWritable, ?>> getMapperClass() {
		return CommitActionsMapper.class;
	}

	@Override
	protected Class<?> getMapOutputValueClass() {
		return Put.class;
	}

	@Override
	protected void addSpecificFilters(FilterList filters) {
		filters.addFilter(new PrefixFilter(Bytes.toBytes("aac|")));
	}

	@Override
	protected void addSpecificScanClauses(Scan scan) {
		//scan.addFamily(Bytes.toBytes("target"));
	}
}