/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dataimport.DeleteRecordsMapper;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class DeleteRecordsJob
extends AbstractHBaseMapReduceJob {
    @Override
    protected Job setJobDetails(Job job, Properties p) throws Exception {
        this.initMapper(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.setOutputFormatClass(TableOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Delete.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
        return job;
    }

    private void initMapper(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, DeleteRecordsMapper.class, Text.class, ImmutableBytesWritable.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(500);
        scan.setCacheBlocks(false);
        return scan;
    }
}

