/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import eu.dnetlib.data.transform.XsltRowTransformer;
import eu.dnetlib.data.transform.XsltRowTransformerFactory;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ImportRecordsMapper
extends Mapper<Text, Text, ImmutableBytesWritable, Put> {
    private static final boolean WRITE_TO_WAL = false;
    private XsltRowTransformer transformer;
    private String xslt;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.xslt = context.getConfiguration().get("hbase.import.xslt").trim();
        if (this.xslt == null || this.xslt.isEmpty()) {
            throw new IllegalArgumentException("missing xslt");
        }
        this.transformer = new XsltRowTransformerFactory().getTransformer(this.xslt);
        this.ibw = new ImmutableBytesWritable();
        System.out.println("using trasformer: '" + this.transformer.getTransformerClassName() + "'");
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        for (Row row : this.transformer.apply(value.toString())) {
            byte[] rowKey = Bytes.toBytes((String)row.getKey());
            Put put = new Put(rowKey);
            put.setWriteToWAL(false);
            for (Column col : row) {
                byte[] family = Bytes.toBytes((String)row.getColumnFamily());
                byte[] qualifier = Bytes.toBytes((String)((String)col.getName()));
                put.add(family, qualifier, (byte[])col.getValue());
            }
            this.ibw.set(rowKey);
            context.write((Object)this.ibw, (Object)put);
            context.getCounter("mdstore", row.getColumnFamily()).increment((long)row.getColumns().size());
        }
    }
}

