/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.index.solr.feed.StreamingInputDocumentFactory;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;

public class IndexFeedMapper
extends Mapper<Text, Text, Text, Text> {
    private InputDocumentFactory documentFactory;
    private CloudSolrServer solrServer;
    private String version;
    private String dsId;
    private int shutdownWaitTime = 10000;
    private int bufferFlushThreshold = 100;
    private ApplyXslt dmfToRecord;
    private List<SolrInputDocument> buffer;
    private int backoffTimeMs = 5000;
    private boolean simulation = false;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.logConfiguration(context.getConfiguration());
        this.dsId = context.getConfiguration().get("id");
        this.shutdownWaitTime = Integer.parseInt(context.getConfiguration().get("index.shutdown.wait.time"));
        this.bufferFlushThreshold = Integer.parseInt(context.getConfiguration().get("index.buffer.flush.threshold"));
        this.documentFactory = new StreamingInputDocumentFactory();
        this.version = InputDocumentFactory.getParsedDateField((String)context.getConfiguration().get("index.feed.timestamp"));
        this.buffer = Lists.newArrayList();
        this.simulation = Boolean.parseBoolean(context.getConfiguration().get("index.solr.sim.mode"));
        String xslt = new String(Base64.decodeBase64((String)context.getConfiguration().get("index.xslt")));
        System.out.println("got xslt: \n" + xslt);
        System.out.println("got version: " + this.version);
        System.out.println("simulation: " + this.simulation);
        System.out.println("buffer size: " + this.bufferFlushThreshold);
        this.dmfToRecord = new ApplyXslt(xslt);
        String baseURL = context.getConfiguration().get("index.solr.url");
        System.out.println("solr server baseURL: " + baseURL);
        String collection = context.getConfiguration().get("index.solr.collection");
        System.out.println("solr server collection: " + collection);
        while (true) {
            try {
                System.out.println("initializing solr server...");
                this.solrServer = new CloudSolrServer(baseURL);
                this.solrServer.connect();
                this.solrServer.setParallelUpdates(true);
                this.solrServer.setDefaultCollection(collection);
                SolrPingResponse rsp = this.solrServer.ping();
                if (rsp.getStatus() != 0) {
                    throw new SolrServerException("bad init status: " + rsp.getStatus());
                }
            }
            catch (Throwable e) {
                if (this.solrServer != null) {
                    this.solrServer.shutdown();
                }
                context.getCounter("index init", e.getMessage()).increment(1L);
                System.out.println(String.format("failed to init solr client wait %dms", this.backoffTimeMs));
                Thread.sleep(this.backoffTimeMs);
                continue;
            }
            break;
        }
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String indexRecord = "";
        SolrInputDocument doc = null;
        try {
            indexRecord = this.dmfToRecord.evaluate((Object)value.toString());
            doc = this.documentFactory.parseDocument(this.version, indexRecord, this.dsId, "dnetResult");
        }
        catch (XMLStreamException e) {
            this.handleError(key, value, context, indexRecord, doc, e);
        }
        while (true) {
            try {
                this.addDocument(context, doc);
                return;
            }
            catch (Throwable e) {
                context.getCounter("index feed", "retries").increment(1L);
                this.handleError(key, value, context, indexRecord, doc, e);
                System.out.println(String.format("failed to feed documents, waiting %dms", this.backoffTimeMs));
                Thread.sleep(this.backoffTimeMs);
                continue;
            }
            break;
        }
    }

    private void addDocument(Mapper.Context context, SolrInputDocument doc) throws SolrServerException, IOException {
        if (!doc.isEmpty()) {
            this.buffer.add(doc);
            if (this.buffer.size() >= this.bufferFlushThreshold) {
                this.doAdd(this.buffer, context);
            }
        } else {
            context.getCounter("index feed", "skipped records").increment(1L);
        }
    }

    private void doAdd(List<SolrInputDocument> buffer, Mapper.Context context) throws SolrServerException, IOException {
        if (!this.simulation) {
            long start = System.currentTimeMillis();
            UpdateResponse rsp = this.solrServer.add(buffer);
            long stop = System.currentTimeMillis() - start;
            System.out.println("feed time for " + buffer.size() + " records : " + HumanTime.exactly((long)stop) + "\n");
            int status = rsp.getStatus();
            context.getCounter("index feed", "status code: " + status).increment((long)buffer.size());
            if (status != 0) {
                throw new SolrServerException("bad status: " + status);
            }
        }
        buffer.clear();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        try {
            if (!this.buffer.isEmpty()) {
                this.doAdd(this.buffer, context);
            }
            System.out.println("\nwaiting " + this.shutdownWaitTime + "ms before shutdown");
            Thread.sleep(this.shutdownWaitTime);
            this.solrServer.shutdown();
        }
        catch (SolrServerException e) {
            System.err.println("couldn't shutdown server " + e.getMessage());
        }
    }

    private void handleError(Text key, Text value, Mapper.Context context, String indexRecord, SolrInputDocument doc, Throwable e) throws IOException, InterruptedException {
        context.getCounter("index feed", e.getClass().getName()).increment(1L);
        context.write((Object)key, (Object)this.printRottenRecord(context.getTaskAttemptID().toString(), value, indexRecord, doc));
        e.printStackTrace(System.err);
    }

    private Text printRottenRecord(String taskid, Text value, String indexRecord, SolrInputDocument doc) {
        return new Text("\n**********************************\ntask: " + taskid + "\n" + this.check("original", value.toString() + this.check("indexRecord", indexRecord) + this.check("solrDoc", doc)));
    }

    private String check(String label, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            return "\n " + label + ":\n" + value + "\n";
        }
        return "\n";
    }

    private void logConfiguration(Configuration conf) {
        System.out.println("job configutation #################");
        for (Map.Entry e : conf) {
            System.out.println("'" + (String)e.getKey() + "' : '" + (String)e.getValue() + "'");
        }
        System.out.println("end of job configutation #################\n\n");
    }
}

