package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Predicate;

import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;

public class PersonResultFilter implements Predicate<Oaf> {
	private String key;

	public PersonResultFilter(String key) {
		this.key = key;
	}

	@Override
	public boolean apply(Oaf oaf) {
		final OafRel oafRel = oaf.getRel();
		if (RelType.personResult.equals(oafRel.getRelType())) {
			return !key.contains(oafRel.getSource().replaceAll("^.*\\:\\:", ""));
		}
		return true;
	}
}
