/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;

public class DnetFuzzyFilter
extends FilterBase {
    protected byte[] mask = null;
    protected boolean passedMask = false;
    public static final byte jolly = 63;

    public DnetFuzzyFilter(byte[] mask) {
        this.mask = mask;
    }

    public DnetFuzzyFilter() {
    }

    public byte[] getMask() {
        return this.mask;
    }

    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null || this.mask == null) {
            return true;
        }
        if (length != this.mask.length) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (this.mask[i] == 63 || buffer[i] == this.mask[i]) continue;
            this.passedMask = true;
            return true;
        }
        return false;
    }

    public boolean filterAllRemaining() {
        return this.passedMask;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray((DataOutput)out, (byte[])this.mask);
    }

    public void readFields(DataInput in) throws IOException {
        this.mask = Bytes.readByteArray((DataInput)in);
    }
}

