/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.oai.utils;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import eu.dnetlib.data.mapreduce.hbase.oai.utils.PublisherField;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class RecordFieldsExtractor {
    private List<PublisherField> storeIndices;
    private String duplicateXPath;
    private boolean skipDuplicates = false;

    public Multimap<String, String> extractFields(String record) {
        ArrayListMultimap recordProps = ArrayListMultimap.create();
        try {
            Document doc = new SAXReader().read((Reader)new StringReader(record));
            if (this.skipDuplicates && this.isDuplicate(doc)) {
                recordProps.put((Object)"duplicate", (Object)"true");
            }
            for (PublisherField field : this.storeIndices) {
                for (Map.Entry indexEntry : field.getSources().entries()) {
                    String xpath = (String)indexEntry.getValue();
                    List xPathResult = doc.selectNodes(xpath);
                    if (xPathResult == null || xPathResult.isEmpty()) continue;
                    if (this.containsStrings(xPathResult)) {
                        recordProps.putAll((Object)field.getFieldName(), (Iterable)xPathResult);
                        continue;
                    }
                    if (!this.containsNodes(xPathResult)) continue;
                    recordProps.putAll((Object)field.getFieldName(), Iterables.transform((Iterable)xPathResult, (Function)new Function<Object, String>(){

                        public String apply(Object obj) {
                            if (obj == null) {
                                return "";
                            }
                            Node node = (Node)obj;
                            return node.getText();
                        }
                    }));
                }
            }
        }
        catch (DocumentException e) {
            recordProps = null;
        }
        return recordProps;
    }

    public boolean isDuplicate(Document doc) {
        return doc.selectSingleNode(this.duplicateXPath) != null;
    }

    private boolean containsStrings(List objects) {
        Object first = objects.get(0);
        return first instanceof String;
    }

    private boolean containsNodes(List objects) {
        Object first = objects.get(0);
        return first instanceof Node;
    }

    public List<PublisherField> getStoreIndices() {
        return this.storeIndices;
    }

    public void setStoreIndices(List<PublisherField> storeIndices) {
        this.storeIndices = storeIndices;
    }

    public RecordFieldsExtractor(List<PublisherField> storeIndices) {
        this.storeIndices = storeIndices;
    }

    public RecordFieldsExtractor() {
    }

    public String getDuplicateXPath() {
        return this.duplicateXPath;
    }

    public void setDuplicateXPath(String duplicateXPath) {
        this.duplicateXPath = duplicateXPath;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }
}

