/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.pace.model.Person;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupPersonMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private Text rowKey;
    private ImmutableBytesWritable ibw;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfigLoader.load((String)context.getConfiguration().get("dedup.wf.conf"));
        this.rowKey = new Text();
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable keyIn, Result result, Mapper.Context context) throws IOException, InterruptedException {
        if (DedupUtils.isRoot(new String(keyIn.copyBytes()))) {
            context.getCounter(this.dedupConf.getEntityType(), "roots skipped").increment(1L);
            return;
        }
        byte[] body = result.getValue(this.dedupConf.getEntityNameBytes(), DedupUtils.BODY_B);
        if (body != null) {
            try {
                OafDecoder decoder = OafDecoder.decode((byte[])body);
                String hash = new Person(decoder.getEntity().getPerson().getMetadata().getFullname().getValue(), false).hash();
                this.rowKey.set(hash);
                this.ibw.set(body);
                context.write((Object)this.rowKey, (Object)this.ibw);
            }
            catch (Throwable e) {
                System.out.println("GOT EX " + e);
                e.printStackTrace(System.err);
                context.getCounter(this.dedupConf.getEntityType(), e.getClass().toString()).increment(1L);
            }
        } else {
            context.getCounter(this.dedupConf.getEntityType(), "missing body").increment(1L);
        }
    }
}

