/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextDef;
import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.hbase.index.config.RelClasses;
import eu.dnetlib.data.mapreduce.util.LicenseComparator;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.mapreduce.util.TemplateFactory;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;

public class XmlRecordFactory {
    protected Set<String> specialDatasourceTypes = Sets.newHashSet((Object[])new String[]{"scholarcomminfra", "infospace", "pubsrepository::mock", "entityregistry"});
    protected TemplateFactory templateFactory = new TemplateFactory();
    protected OafDecoder mainEntity = null;
    protected String key = null;
    protected List<OafDecoder> relations = Lists.newLinkedList();
    protected List<OafDecoder> children = Lists.newLinkedList();
    protected EntityConfigTable entityConfigTable;
    protected ContextMapper contextMapper;
    protected RelClasses relClasses;
    protected String schemaLocation;
    protected boolean entityDefaults;
    protected boolean relDefaults;
    protected boolean childDefaults;
    protected Set<String> contextes = Sets.newHashSet();
    protected List<String> extraInfo = Lists.newArrayList();
    protected Map<String, Integer> counters = Maps.newHashMap();
    protected Transformer transformer;

    public XmlRecordFactory(EntityConfigTable entityConfigTable, ContextMapper contextMapper, RelClasses relClasses, String schemaLocation, boolean entityDefaults, boolean relDefaults, boolean childDefeaults) throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        this.entityConfigTable = entityConfigTable;
        this.contextMapper = contextMapper;
        this.relClasses = relClasses;
        this.schemaLocation = schemaLocation;
        this.entityDefaults = entityDefaults;
        this.relDefaults = relDefaults;
        this.childDefaults = childDefeaults;
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("omit-xml-declaration", "yes");
    }

    public String getId() {
        return this.key;
    }

    public boolean isValid() {
        return this.mainEntity != null;
    }

    public void setMainEntity(OafDecoder mainEntity) {
        this.mainEntity = mainEntity;
        this.key = mainEntity.decodeEntity().getId();
    }

    public void addRelation(OafDecoder rel) {
        this.addRelOrChild(this.relations, rel);
    }

    public void addChild(OafDecoder child) {
        this.addRelOrChild(this.children, child);
    }

    private void addRelOrChild(List<OafDecoder> list, OafDecoder decoder) {
        list.add(decoder);
    }

    public String build() {
        OafEntityDecoder entity = this.mainEntity.decodeEntity();
        TypeProtos.Type type = entity.getType();
        List<String> metadata = this.decodeType(entity, null, this.entityDefaults, false);
        List<String> rels = this.listRelations();
        metadata.addAll(this.buildContexts(type));
        metadata.add(this.parseDataInfo(this.mainEntity));
        String body = this.templateFactory.buildBody(type, metadata, rels, this.listChildren(), this.extraInfo);
        return this.templateFactory.buildRecord(type, this.key, entity.getDateOfCollection(), this.schemaLocation, body, this.countersAsXml());
    }

    private String parseDataInfo(OafDecoder decoder) {
        FieldTypeProtos.DataInfo dataInfo = decoder.getOaf().getDataInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("<datainfo>");
        sb.append(this.asXmlElement("inferred", dataInfo.getInferred() + "", null, null));
        sb.append(this.asXmlElement("deletedbyinference", dataInfo.getDeletedbyinference() + "", null, null));
        sb.append(this.asXmlElement("trust", dataInfo.getTrust() + "", null, null));
        sb.append(this.asXmlElement("inferenceprovenance", dataInfo.getInferenceprovenance() + "", null, null));
        sb.append(this.asXmlElement("provenanceaction", null, dataInfo.getProvenanceaction(), null));
        sb.append("</datainfo>");
        return sb.toString();
    }

    private List<String> decodeType(OafEntityDecoder decoder, Set<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        metadata.addAll(this.listFields(decoder.getMetadata(), filter, defaults, expandingRel));
        metadata.addAll(this.listFields(decoder.getOafEntity(), filter, defaults, expandingRel));
        if (decoder.getEntity() instanceof ResultProtos.Result && !expandingRel) {
            metadata.add(this.asXmlElement("bestlicense", "", this.getBestLicense(), null));
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        if (decoder.getEntity() instanceof PersonProtos.Person && !expandingRel) {
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        if (decoder.getEntity() instanceof ProjectProtos.Project && !expandingRel) {
            metadata.addAll(this.listFields(decoder.getEntity(), filter, defaults, expandingRel));
        }
        return metadata;
    }

    private FieldTypeProtos.Qualifier getBestLicense() {
        FieldTypeProtos.Qualifier bestLicense = this.getQualifier("UNKNOWN", "not available", "dnet:access_modes");
        LicenseComparator lc = new LicenseComparator();
        for (ResultProtos.Result.Instance instance : ((ResultProtos.Result)this.mainEntity.decodeEntity().getEntity()).getInstanceList()) {
            if (lc.compare(bestLicense, instance.getLicence()) <= 0) continue;
            bestLicense = instance.getLicence();
        }
        return bestLicense;
    }

    public FieldTypeProtos.Qualifier getQualifier(String classid, String classname, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(schemename).setSchemename(schemename).build();
    }

    private List<String> listRelations() {
        ArrayList rels = Lists.newArrayList();
        for (OafDecoder decoder : this.relations) {
            RelMetadataProtos.RelMetadata relMetadata;
            OafProtos.OafRel rel = decoder.getOafRel();
            OafProtos.OafEntity cachedTarget = rel.getCachedTarget();
            OafRelDecoder relDecoder = OafRelDecoder.decode((OafProtos.OafRel)rel);
            if (!relDecoder.getRelSourceId().equals(this.key) && !relDecoder.getRelTargetId().equals(this.key)) continue;
            ArrayList metadata = Lists.newArrayList();
            TypeProtos.Type targetType = relDecoder.getTargetType(this.mainEntity.getEntity().getType());
            Set<String> relFilter = this.entityConfigTable.getFilter(targetType, relDecoder.getRelDescriptor());
            metadata.addAll(this.listFields(relDecoder.getSubRel(), relFilter, false, true));
            String semanticclass = "";
            String semanticscheme = "";
            RelDescriptor relDescriptor = relDecoder.getRelDescriptor();
            if (cachedTarget != null && cachedTarget.isInitialized()) {
                Set<String> filter = this.entityConfigTable.getFilter(targetType, relDescriptor);
                metadata.addAll(this.decodeType(OafEntityDecoder.decode((OafProtos.OafEntity)cachedTarget), filter, this.relDefaults, true));
            }
            if ((relMetadata = relDecoder.getRelMetadata()) == null) {
                semanticscheme = "UNKNOWN";
                semanticclass = "UNKNOWN";
            } else {
                semanticclass = this.relClasses.getInverse(relMetadata.getSemantics().getClassname());
                semanticscheme = relMetadata.getSemantics().getSchemename();
            }
            this.incrementCounter(relDescriptor.getSubRelType().toString());
            LinkDescriptor ld = this.entityConfigTable.getDescriptor(relDecoder.getTargetType(this.mainEntity.getEntity().getType()), relDescriptor);
            String relId = ld != null && !ld.isSymmetric() ? relDecoder.getRelTargetId() : relDecoder.getRelSourceId();
            FieldTypeProtos.DataInfo info = decoder.getOaf().getDataInfo();
            rels.add(this.templateFactory.getRel(targetType, relId, metadata, semanticclass, semanticscheme, info.getInferred(), info.getTrust(), info.getInferenceprovenance(), info.getProvenanceaction().getClassid()));
        }
        return rels;
    }

    private List<String> listChildren() {
        ArrayList children = Lists.newArrayList();
        for (OafDecoder decoder : this.children) {
            OafProtos.OafEntity cachedTarget = decoder.getOafRel().getCachedTarget();
            this.addChildren(children, cachedTarget, decoder.getRelDescriptor());
        }
        OafEntityDecoder entity = this.mainEntity.decodeEntity();
        if (entity.getType().equals((Object)TypeProtos.Type.result)) {
            for (ResultProtos.Result.Instance instance : ((ResultProtos.Result)entity.getEntity()).getInstanceList()) {
                children.add(this.templateFactory.getInstance(instance.getHostedby().getKey(), this.listFields((GeneratedMessage)instance, null, false, false), MappedCollection.listMap((Iterable)instance.getUrlList(), (UnaryFunction)new UnaryFunction<String, String>(){

                    public String evaluate(String identifier) {
                        return XmlRecordFactory.this.templateFactory.getWebResource(identifier);
                    }
                })));
            }
            for (ResultProtos.Result.ExternalReference er : ((ResultProtos.Result)entity.getEntity()).getExternalReferenceList()) {
                List<String> fields = this.listFields((GeneratedMessage)er, null, false, false);
                children.add(this.templateFactory.getChild("externalreference", null, fields));
            }
        }
        return children;
    }

    private void addChildren(List<String> children, OafProtos.OafEntity target, RelDescriptor relDescriptor) {
        OafEntityDecoder decoder = OafEntityDecoder.decode((OafProtos.OafEntity)target);
        this.incrementCounter(relDescriptor.getSubRelType().toString());
        Set<String> filters = this.entityConfigTable.getFilter(target.getType(), relDescriptor);
        children.add(this.templateFactory.getChild(decoder.getType().toString(), decoder.getId(), this.listFields(decoder.getMetadata(), filters, this.childDefaults, false)));
    }

    private List<String> listFields(GeneratedMessage fields, Set<String> filter, boolean defaults, boolean expandingRel) {
        ArrayList metadata = Lists.newArrayList();
        if (fields != null) {
            HashSet seen = Sets.newHashSet();
            for (Map.Entry<Descriptors.FieldDescriptor, Object> e : this.filterFields(fields, filter)) {
                String name = e.getKey().getName();
                seen.add(name);
                this.addFieldValue(metadata, e.getKey(), e.getValue(), expandingRel);
            }
            if (defaults) {
                for (Descriptors.FieldDescriptor fd : fields.getDescriptorForType().getFields()) {
                    if (seen.contains(fd.getName())) continue;
                    this.addFieldValue(metadata, fd, this.getDefault(fd), expandingRel);
                }
            }
        }
        return metadata;
    }

    private Object getDefault(Descriptors.FieldDescriptor fd) {
        switch (fd.getType()) {
            case BOOL: {
                return false;
            }
            case BYTES: {
                return "".getBytes();
            }
            case MESSAGE: {
                if (FieldTypeProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                    return this.defaultQualifier();
                }
                if (FieldTypeProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.StructuredProperty.newBuilder().setValue("").setQualifier(this.defaultQualifier()).build();
                }
                if (FieldTypeProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.KeyValue.newBuilder().setKey("").setValue("").build();
                }
                if (FieldTypeProtos.StringField.getDescriptor().equals(fd.getMessageType())) {
                    return FieldTypeProtos.StringField.newBuilder().setValue("").build();
                }
                return null;
            }
            case SFIXED32: 
            case SFIXED64: 
            case SINT32: 
            case SINT64: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FIXED32: 
            case FIXED64: 
            case FLOAT: {
                return 0;
            }
            case STRING: {
                return "";
            }
        }
        return null;
    }

    private FieldTypeProtos.Qualifier defaultQualifier() {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid("").setClassname("").setSchemeid("").setSchemename("").build();
    }

    private void addFieldValue(List<String> metadata, Descriptors.FieldDescriptor fd, Object value, boolean expandingRel) {
        if (fd.getName().equals("dateofcollection") || fd.getName().equals("id") || fd.getName().equals("url") || value == null) {
            return;
        }
        if (fd.getName().equals("datasourcetype")) {
            String classid = ((FieldTypeProtos.Qualifier)value).getClassid();
            FieldTypeProtos.Qualifier.Builder q = FieldTypeProtos.Qualifier.newBuilder((FieldTypeProtos.Qualifier)((FieldTypeProtos.Qualifier)value));
            if (this.specialDatasourceTypes.contains(classid)) {
                q.setClassid("other").setClassname("other");
            }
            metadata.add(this.asXmlElement("datasourcetypeui", "", q.build(), null));
        }
        if (fd.isRepeated() && value instanceof List) {
            for (Object o : (List)value) {
                this.guessType(metadata, fd, o, expandingRel);
            }
        } else {
            this.guessType(metadata, fd, value, expandingRel);
        }
    }

    private void guessType(List<String> metadata, Descriptors.FieldDescriptor fd, Object o, boolean expandingRel) {
        if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            if (FieldTypeProtos.Qualifier.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.Qualifier qualifier = (FieldTypeProtos.Qualifier)o;
                metadata.add(this.asXmlElement(fd.getName(), "", qualifier, null));
            }
            if (FieldTypeProtos.StructuredProperty.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.StructuredProperty sp = (FieldTypeProtos.StructuredProperty)o;
                metadata.add(this.asXmlElement(fd.getName(), sp.getValue(), sp.getQualifier(), sp.hasDataInfo() ? sp.getDataInfo() : null));
            }
            if (FieldTypeProtos.KeyValue.getDescriptor().equals(fd.getMessageType())) {
                FieldTypeProtos.KeyValue kv = (FieldTypeProtos.KeyValue)o;
                metadata.add("<" + fd.getName() + " name=\"" + XmlRecordFactory.escapeXml(kv.getValue()) + "\" id=\"" + XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(kv.getKey())) + "\"/>");
            }
            if (FieldTypeProtos.StringField.getDescriptor().equals(fd.getMessageType())) {
                String fieldName = fd.getName();
                if (fieldName.equals("fundingtree")) {
                    String xmlTree;
                    String string = xmlTree = o instanceof FieldTypeProtos.StringField ? ((FieldTypeProtos.StringField)o).getValue() : o.toString();
                    if (expandingRel) {
                        metadata.add(this.getRelFundingTree(xmlTree));
                        this.fillContextMap(xmlTree);
                    } else {
                        metadata.add(xmlTree);
                    }
                } else {
                    FieldTypeProtos.StringField sf = (FieldTypeProtos.StringField)o;
                    StringBuilder sb = new StringBuilder("<" + fd.getName());
                    if (sf.hasDataInfo()) {
                        FieldTypeProtos.DataInfo dataInfo = sf.getDataInfo();
                        this.dataInfoAsAttributes(sb, dataInfo);
                    }
                    sb.append(">" + XmlRecordFactory.escapeXml(sf.getValue()) + "</" + fd.getName() + ">");
                    metadata.add(sb.toString());
                }
            }
            if (ResultProtos.Result.Journal.getDescriptor().equals(fd.getMessageType()) && o != null) {
                ResultProtos.Result.Journal j = (ResultProtos.Result.Journal)o;
                metadata.add("<journal issn=\"" + XmlRecordFactory.escapeXml(j.getIssnPrinted()) + "\" " + "eissn=\"" + XmlRecordFactory.escapeXml(j.getIssnOnline()) + "\" " + "lissn=\"" + XmlRecordFactory.escapeXml(j.getIssnLinking()) + "\">" + XmlRecordFactory.escapeXml(j.getName()) + "</journal>");
            }
            if (ResultProtos.Result.Context.getDescriptor().equals(fd.getMessageType()) && o != null) {
                this.contextes.add(((ResultProtos.Result.Context)o).getId());
            }
            if (FieldTypeProtos.ExtraInfo.getDescriptor().equals(fd.getMessageType()) && o != null) {
                FieldTypeProtos.ExtraInfo e = (FieldTypeProtos.ExtraInfo)o;
                StringBuilder sb = new StringBuilder("<" + fd.getName() + " ");
                sb.append("name=\"" + e.getName() + "\" ");
                sb.append("typology=\"" + e.getTypology() + "\" ");
                sb.append("provenance=\"" + e.getProvenance() + "\" ");
                sb.append("trust=\"" + e.getTrust() + "\"");
                sb.append(">");
                sb.append(e.getValue());
                sb.append("</" + fd.getName() + ">");
                this.extraInfo.add(sb.toString());
            }
        } else if (fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            if (fd.getFullName().equals("eu.dnetlib.data.proto.OafEntity.type")) {
                return;
            }
            metadata.add(this.asXmlElement(fd.getName(), ((Descriptors.EnumValueDescriptor)o).getName(), null, null));
        } else {
            metadata.add(this.asXmlElement(fd.getName(), o.toString(), null, null));
        }
    }

    private StringBuilder dataInfoAsAttributes(StringBuilder sb, FieldTypeProtos.DataInfo dataInfo) {
        sb.append(" inferred=\"" + dataInfo.getInferred() + "\"");
        sb.append(" inferenceprovenance=\"" + dataInfo.getInferenceprovenance() + "\"");
        sb.append(" provenanceaction=\"" + dataInfo.getProvenanceaction().getClassid() + "\"");
        sb.append(" trust=\"" + dataInfo.getTrust() + "\" ");
        return sb;
    }

    private List<String> buildContexts(TypeProtos.Type type) {
        ArrayList res = Lists.newArrayList();
        if (this.contextMapper != null && !this.contextMapper.isEmpty() && type.equals((Object)TypeProtos.Type.result)) {
            XMLTag document = XMLDoc.newDocument((boolean)true).addRoot("contextRoot");
            for (String id : this.contextes) {
                StringTokenizer st = new StringTokenizer(id, "::");
                String token = "";
                while (st.hasMoreTokens()) {
                    ContextDef def = (ContextDef)this.contextMapper.get(token = token + st.nextToken());
                    if (def == null) {
                        throw new IllegalStateException("cannot find context for id: " + token);
                    }
                    if (def.getName().equals("context")) {
                        String xpath = "//context/@id='" + def.getId() + "'";
                        if (!document.gotoRoot().rawXpathBoolean(xpath, new Object[]{new Object()}).booleanValue()) {
                            document = this.addContextDef(document.gotoRoot(), def);
                        }
                    }
                    if (def.getName().equals("category")) {
                        String rootId = StringUtils.substringBefore((String)def.getId(), (String)"::");
                        document = this.addContextDef(document.gotoRoot().gotoTag("//context[./@id='" + rootId + "']", new Object[]{new Object()}), def);
                    }
                    if (def.getName().equals("concept")) {
                        document = this.addContextDef(document, def).gotoParent();
                    }
                    token = token + "::";
                }
            }
            for (Element x : document.gotoRoot().getChildElement()) {
                try {
                    res.add(this.asStringElement(x));
                }
                catch (TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return res;
    }

    private XMLTag addContextDef(XMLTag tag, ContextDef def) {
        tag.addTag(def.getName()).addAttribute("id", def.getId()).addAttribute("label", def.getLabel());
        if (def.getType() != null && !def.getType().isEmpty()) {
            tag.addAttribute("type", def.getType());
        }
        return tag;
    }

    private String asStringElement(Element element) throws TransformerException {
        StringWriter buffer = new StringWriter();
        this.transformer.transform(new DOMSource(element), new StreamResult(buffer));
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRelFundingTree(String xmlTree) {
        String funding = "<funding>";
        try {
            Document ftree = new SAXReader().read((Reader)new StringReader(xmlTree));
            funding = "<funding>";
            for (Object o : Lists.reverse((List)ftree.selectNodes("//fundingtree//*[starts-with(local-name(),'funding_level_')]"))) {
                org.dom4j.Element e = (org.dom4j.Element)o;
                String _id = e.valueOf("./id");
                funding = funding + "<" + e.getName() + ">" + XmlRecordFactory.escapeXml(_id) + "</" + e.getName() + ">";
            }
        }
        catch (DocumentException e) {
            System.err.println("unable to parse funding tree: " + xmlTree + "\n" + e.getMessage());
        }
        finally {
            funding = funding + "</funding>";
        }
        return funding;
    }

    private void fillContextMap(String xmlTree) {
        Document fundingPath;
        try {
            fundingPath = new SAXReader().read((Reader)new StringReader(xmlTree));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Node funder = fundingPath.selectSingleNode("//funder");
        String funderShortName = funder.valueOf("./shortname");
        this.contextMapper.put(funderShortName, new ContextDef(funderShortName, funder.valueOf("./name"), "context", "funding"));
        Node level0 = fundingPath.selectSingleNode("//funding_level_0");
        String level0Id = Joiner.on((String)"::").join((Object)funderShortName, (Object)level0.valueOf("./name"), new Object[0]);
        this.contextMapper.put(level0Id, new ContextDef(level0Id, level0.valueOf("./description"), "category", ""));
        Node level1 = fundingPath.selectSingleNode("//funding_level_1");
        String level1Id = Joiner.on((String)"::").join((Object)level0Id, (Object)level1.valueOf("./name"), new Object[0]);
        this.contextMapper.put(level1Id, new ContextDef(level1Id, level1.valueOf("./description"), "concept", ""));
        Node level2 = fundingPath.selectSingleNode("//funding_level_2");
        if (level2 == null) {
            this.contextes.add(level1Id);
        } else {
            String level2Id = Joiner.on((String)"::").join((Object)level1Id, (Object)level2.valueOf("./name"), new Object[0]);
            this.contextMapper.put(level2Id, new ContextDef(level2Id, level2.valueOf("./description"), "concept", ""));
            this.contextes.add(level2Id);
        }
    }

    private String asXmlElement(String name, String value, FieldTypeProtos.Qualifier q, FieldTypeProtos.DataInfo dataInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(name);
        if (q != null) {
            sb.append(this.getAttributes(q));
        }
        if (dataInfo != null) {
            sb = this.dataInfoAsAttributes(sb, dataInfo);
        }
        if (value == null || value.isEmpty()) {
            sb.append("/>");
            return sb.toString();
        }
        sb.append(">");
        sb.append(XmlRecordFactory.escapeXml(value));
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    private String getAttributes(FieldTypeProtos.Qualifier q) {
        if (q == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : q.getAllFields().entrySet()) {
            sb.append(" ");
            sb.append(((Descriptors.FieldDescriptor)e.getKey()).getName());
            sb.append("=\"");
            sb.append(XmlRecordFactory.escapeXml(e.getValue().toString()));
            sb.append("\"");
        }
        return sb.toString();
    }

    private Set<Map.Entry<Descriptors.FieldDescriptor, Object>> filterFields(final GeneratedMessage fields, final Set<String> filter) {
        if (filter != null) {
            Predicate<Descriptors.FieldDescriptor> p = new Predicate<Descriptors.FieldDescriptor>(){

                public boolean apply(Descriptors.FieldDescriptor descriptor) {
                    if (fields == null) {
                        return false;
                    }
                    String name = descriptor.getName();
                    return filter.contains(name);
                }
            };
            Map filtered = Maps.filterKeys((Map)fields.getAllFields(), (Predicate)p);
            return filtered.entrySet();
        }
        return fields.getAllFields().entrySet();
    }

    public static String removePrefix(String s) {
        if (s.contains("|")) {
            return StringUtils.substringAfter((String)s, (String)"|");
        }
        return s;
    }

    public static String escapeXml(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private List<String> countersAsXml() {
        ArrayList out = Lists.newArrayList();
        for (Map.Entry<String, Integer> e : this.counters.entrySet()) {
            out.add(String.format("<counter_%s value=\"%s\"/>", e.getKey(), e.getValue()));
        }
        return out;
    }

    private void incrementCounter(String type) {
        if (!this.counters.containsKey(type)) {
            this.counters.put(type, 1);
        } else {
            this.counters.put(type, this.counters.get(type) + 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("################################################\n");
        sb.append("ID: ").append(this.key).append("\n");
        if (this.mainEntity != null) {
            sb.append("MAIN ENTITY:\n").append(this.mainEntity.getEntity().toString() + "\n");
        }
        if (this.relations != null) {
            sb.append("\nRELATIONS:\n");
            for (OafDecoder decoder : this.relations) {
                sb.append(decoder.getOafRel().toString() + "\n");
            }
        }
        if (this.children != null) {
            sb.append("\nCHILDREN:\n");
            for (OafDecoder decoder : this.children) {
                sb.append(decoder.getOafRel().toString() + "\n");
            }
        }
        return sb.toString();
    }
}

