/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import eu.dnetlib.data.mapreduce.hbase.index.config.ContextMapper;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.IndexConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.RelClasses;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.XmlRecordFactory;
import java.io.IOException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class PrepareFeedReducer
extends Reducer<Text, ImmutableBytesWritable, Text, Text> {
    private EntityConfigTable entityConfigTable;
    private ContextMapper contextMapper = new ContextMapper();
    private RelClasses relClasses;
    private String schemaLocation;
    private final boolean entityDefaults = true;
    private final boolean relDefaults = false;
    private final boolean childDefaults = false;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        String json = context.getConfiguration().get("index.entity.links");
        System.out.println("index.entity.links:\n" + json);
        this.entityConfigTable = IndexConfig.load(json).getConfigMap();
        this.schemaLocation = context.getConfiguration().get("oaf.schema.location");
        System.out.println("schema location:\n" + this.schemaLocation);
        String contextMap = context.getConfiguration().get("contextmap");
        System.out.println("contextmap:\n" + contextMap);
        try {
            this.contextMapper = ContextMapper.fromXml(contextMap);
        }
        catch (DocumentException e) {
            System.err.println("unable to parse contextMap: " + contextMap);
        }
        String relClassJson = context.getConfiguration().get("relClasses");
        System.out.println("relClassesJson:\n" + relClassJson);
        this.relClasses = new RelClasses(relClassJson);
        System.out.println("relClasses:\n" + this.relClasses);
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((String)key.toString());
        try {
            XmlRecordFactory builder = new XmlRecordFactory(this.entityConfigTable, this.contextMapper, this.relClasses, this.schemaLocation, true, false, false);
            this.decodeValues(values, builder);
            if (builder.isValid()) {
                context.write((Object)keyDecoder.getKeyAsText(), (Object)new Text(builder.build()));
            } else {
                context.getCounter("missing body", keyDecoder.getType().toString()).increment(1L);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    private void decodeValues(Iterable<ImmutableBytesWritable> values, XmlRecordFactory builder) {
        block4: for (ImmutableBytesWritable bytes : values) {
            OafDecoder decoder = OafHbaseUtils.decode(bytes);
            switch (decoder.getKind()) {
                case entity: {
                    builder.setMainEntity(decoder);
                    continue block4;
                }
                case relation: {
                    if (decoder.getOafRel().getChild()) {
                        builder.addChild(decoder);
                        continue block4;
                    }
                    builder.addRelation(decoder);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unknow type: " + decoder.getKind());
        }
    }
}

