/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase;

import eu.dnetlib.data.hadoop.config.ClusterName;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.mapreduce.HadoopJob;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.beans.factory.BeanNameAware;

public abstract class AbstractHBaseMapReduceJob
extends Configured
implements HadoopJob,
BeanNameAware {
    protected static final Log log = LogFactory.getLog(AbstractHBaseMapReduceJob.class);
    protected String jobName;
    @Resource
    protected ConfigurationEnumerator configurationEnumerator;

    protected abstract Job setJobDetails(Job var1, Properties var2) throws Exception;

    public Job setJobDetails(ClusterName name, Properties p) {
        try {
            Job job = this.createJobCommon(name, p);
            return this.setJobDetails(job, p);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to define Job: " + ((Object)((Object)this)).getClass().getSimpleName(), e);
        }
    }

    protected Job createJobCommon(ClusterName name, Properties p) throws IOException {
        Job job = new Job(this.configurationEnumerator.get(name), ((Object)((Object)this)).getClass().getSimpleName());
        this.merge(job, p);
        return job;
    }

    protected void merge(Job job, Properties p) {
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            job.getConfiguration().set((String)e.getKey(), (String)e.getValue());
        }
    }

    protected void deleteHdfsFile(Job job, Path path) {
        try {
            FileSystem hdfs = FileSystem.get((Configuration)job.getConfiguration());
            if (hdfs.exists(path)) {
                hdfs.delete(path, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBeanName(String name) {
        this.jobName = name;
    }

    public String getName() {
        return this.jobName;
    }
}

