/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.VolatileColumnFamily;
import eu.dnetlib.data.proto.RelTypeProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class FindPersonCoauthorsMapper
extends TableMapper<Text, Text> {
    private final HttpClient client = new DefaultHttpClient();
    private final String url = "http://146.48.87.97:8888/addData";

    protected void setup(Mapper.Context context) {
    }

    protected void map(ImmutableBytesWritable rowkey, Result row, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap candidates = row.getFamilyMap(Bytes.toBytes((String)VolatileColumnFamily.dedupPerson.toString()));
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        ArrayList coauthors = Lists.newArrayList();
        for (byte[] b : row.getFamilyMap(Bytes.toBytes((String)RelTypeProtos.RelType.personResult.toString())).keySet()) {
            coauthors.add(Bytes.toString((byte[])b));
        }
        for (byte[] candidate : candidates.keySet()) {
            this.emit(context, Bytes.toString((byte[])candidate), coauthors);
        }
    }

    private void emit(Mapper.Context context, String candidate, List<String> coauthors) {
        try {
            HttpPost request = new HttpPost("http://146.48.87.97:8888/addData");
            BasicHttpParams params = new BasicHttpParams();
            params.setParameter("id", (Object)candidate);
            params.setParameter("data", (Object)new Gson().toJson(coauthors));
            request.setParams((HttpParams)params);
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            context.getCounter("HTTP call", "code " + response.getStatusLine().getStatusCode()).increment(1L);
        }
        catch (Exception e) {
            context.getCounter("HTTP call", "Exception " + e.getClass()).increment(1L);
        }
    }
}

