/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.gt.GTAuthor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupFindRootsPersonMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private ImmutableBytesWritable outKey;
    private ImmutableBytesWritable outValue;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
        this.outKey = new ImmutableBytesWritable();
        this.outValue = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = TypeProtos.Type.valueOf((String)this.dedupConf.getWf().getEntityType());
        NavigableMap similarRels = value.getFamilyMap(DedupUtils.getSimilarityCFBytes(type));
        if (similarRels != null && !similarRels.isEmpty()) {
            ByteBuffer min = this.findMin(ByteBuffer.wrap(rowkey.get()), similarRels.keySet());
            byte[] groupingKey = DedupUtils.newIdBytes(min, this.dedupConf.getWf().getDedupRun());
            GTAuthor gta = this.asGTA(context, rowkey, value.getValue(Bytes.toBytes((String)this.dedupConf.getWf().getEntityType()), DedupUtils.BODY_B));
            this.emitBody(context, groupingKey, gta);
        } else {
            context.getCounter(this.dedupConf.getWf().getEntityType(), "row not in similarity mesh").increment(1L);
        }
    }

    private GTAuthor asGTA(Mapper.Context context, ImmutableBytesWritable rowkey, byte[] input) {
        OafDecoder decoder = OafDecoder.decode((byte[])input);
        OafProtos.Oaf oaf = decoder.getOaf();
        PersonProtos.Person person = oaf.getEntity().getPerson();
        GTAuthor gta = GTAuthor.fromOafJson((String)JsonFormat.printToString((Message)person));
        gta.setId(new String(rowkey.copyBytes()));
        return gta;
    }

    private ByteBuffer findMin(ByteBuffer min, Iterable<byte[]> keys) {
        for (byte[] q : keys) {
            ByteBuffer iq = ByteBuffer.wrap(q);
            if (min.compareTo(iq) <= 0) continue;
            min = iq;
        }
        return min;
    }

    private void emitBody(Mapper.Context context, byte[] row, GTAuthor gta) throws InvalidProtocolBufferException, IOException, InterruptedException {
        this.outKey.set(row);
        this.outValue.set(this.toOafByteArray(gta));
        context.write((Object)this.outKey, (Object)this.outValue);
        context.getCounter(this.dedupConf.getWf().getEntityType(), "in").increment(1L);
    }

    public byte[] toOafByteArray(GTAuthor gta) {
        return Bytes.toBytes((String)gta.toString());
    }
}

