package eu.dnetlib.data.mapreduce;

public class JobParams {

	public static final int MAX_COUNTERS = 20;

	public static final boolean WRITE_TO_WAL = false;

	public static final String DEDUP_CONF = "dedup.conf";

	public static final String MAPRED_JAR = "mapred.jar";
	public static final String MAPRED_INPUT_DIR = "mapred.input.dir";
	public static final String MAPRED_OUTPUT_DIR = "mapred.output.dir";
	public static final String MAPRED_OUT_DIR = "mapred.out.dir";
	public static final String MAPRED_WORKING_DIR = "mapred.working.dir";
	public static final String MAPRED_LOCAL_DIR = "mapred.local.dir";

	public static final String MONGO_INPUT_URI = "mongo.input.uri";
	public static final String MONGO_OUTPUT_URI = "mongo.output.uri";
	public static final String HBASE_TARGET_TABLE = "hbase.mapred.outputtable";
	public static final String HBASE_TARGET_FAMILY = "hbase.target.family";
	public static final String HBASE_TARGET_QUALIFIER = "hbase.target.qualifier";
	public static final String HBASE_TARGET_TABLE_REGION_SPLITS = "hbase.target.table.region.splits";

	public static final String HBASE_SOURCE_TABLE = "hbase.source.table";
	public static final String HBASE_SOURCE_FAMILY = "hbase.source.family";
	public static final String HBASE_SOURCE_QUALIFIER = "hbase.source.qualifier.body";

	public static final String HBASE_DEST_TABLE = "hbase.dest.table";
	public static final String HBASE_DEST_FAMILY = "hbase.dest.family";
	public static final String HBASE_DEST_QUALIFIER = "hbase.dest.qualifier.body";

	public static final String HBASE_IMPORT_XSLT = "hbase.import.xslt";

	public static final String INDEX_SOLR_URL = "index.solr.url";
	public static final String INDEX_SOLR_URL_ZK = "index.solr.url.zk";
	public static final String INDEX_SOLR_COLLECTION = "index.solr.collection";
	public static final String INDEX_SOLR_URL_LOCAL = "index.solr.url.local";
	public static final String INDEX_SOLR_URL_LIST = "index.solr.url.list";
	public static final String INDEX_SOLR_QUEUE_SIZE = "index.solr.queue.size";
	public static final String INDEX_SOLR_THREAD_COUNT = "index.solr.thread.count";
	public static final String INDEX_SEQ_FILE = "index.solr.seq.file";
	public static final String INDEX_ROTTEN_FILE = "index.solr.rotten.records";
	public static final String INDEX_LOCAL_FEEDING = "index.solr.local.feeding";
	public static final String INDEX_FEED_SIMULATION_MODE = "index.solr.sim.mode";

	public static final String INDEX_ADD_THRESHOLD = "index.add.threshold";
	public static final String INDEX_XSLT = "index.xslt";
	public static final String INDEX_REL_FILTERS = "index.rel.filters";
	public static final String INDEX_ENTITY_LINKS = "index.entity.links";
	public static final String INDEX_FEED_TYPE = "index.feed.type";
	public static final String INDEX_FEED_MODE = "index.feed.mode";
	public static final String INDEX_FEED_WF_MODE = "index.feed.wf.mode";
	public static final String INDEX_FEED_TIME = "index.feed.timestamp";
	public static final String INDEX_NUM_REDUCE_TASK = "index.num.reduce.task";
	public static final String INDEX_DSID = "id";
	public static final String INDEX_SHUTDOWN_WAIT = "index.shutdown.wait.time";
	public static final String INDEX_BUFFER_FLUSH_TRESHOLD = "index.buffer.flush.threshold";

	public static final String HDFS_TMP_DIR = "hdsf.tmp.directory";
	public static final String DEDUP_SEQ_FILE = "dedup.seq.file";

	public static final String STATS_ROTTEN_FILE = "stats.rotten.records";

	public static final String OAI_FEED_DATE = "oai.feed.date";

	public static final String DOCUMENT_DB_ROTTEN_FILE = "document.db.rotten.records";

}
