/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.gt;

import com.google.common.collect.Maps;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class CoAuthorUpdateMapper
extends TableMapper<ImmutableBytesWritable, Put> {
    private Map<String, String> mergedToAnchor;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.mergedToAnchor = Maps.newHashMap();
        String filePath = context.getConfiguration().get("mapred.output.dir") + "/part-r-00000";
        if (StringUtils.isBlank((String)filePath)) {
            throw new IllegalArgumentException("missing 'mapred.output.dir'");
        }
        Path path = new Path(filePath);
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
        String line = br.readLine();
        while (line != null) {
            String[] split = line.split("=");
            this.mergedToAnchor.put(split[0], split[1]);
            line = br.readLine();
        }
        context.getCounter("anchor", "map size").setValue((long)this.mergedToAnchor.size());
        fs.close();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        byte[] body = value.getValue(Bytes.toBytes((String)TypeProtos.Type.person.toString()), DedupUtils.BODY_B);
        OafDecoder d = OafDecoder.decode((byte[])body);
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)d.getOaf());
        List coAuthors = oafBuilder.getEntityBuilder().getPersonBuilder().getCoauthorBuilderList();
        for (PersonProtos.Person.CoAuthor.Builder cb : coAuthors) {
            String newAnchorId = this.mergedToAnchor.get(cb.getId());
            if (newAnchorId != null) {
                context.getCounter("anchor", "hit").increment(1L);
                if (cb.getAnchorId().equals(newAnchorId)) continue;
                cb.setAnchorId(newAnchorId);
                context.getCounter("anchor", "updated").increment(1L);
                continue;
            }
            context.getCounter("anchor", "miss").increment(1L);
        }
        HashMap coAuthorSet = Maps.newHashMap();
        for (PersonProtos.Person.CoAuthor.Builder cb : coAuthors) {
            coAuthorSet.put(cb.hasAnchorId() ? cb.getAnchorId() : cb.getId(), cb.build());
        }
        oafBuilder.getEntityBuilder().getPersonBuilder().clearCoauthor();
        oafBuilder.getEntityBuilder().getPersonBuilder().addAllCoauthor(coAuthorSet.values());
        Put put = new Put(key.copyBytes());
        put.setWriteToWAL(false);
        put.add(Bytes.toBytes((String)TypeProtos.Type.person.toString()), DedupUtils.BODY_B, oafBuilder.build().toByteArray());
        context.write((Object)key, (Object)put);
    }
}

