/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.gt;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class BuildMergedAnchorMapReducer
extends Reducer<ImmutableBytesWritable, Text, Text, Text> {
    private Text outKey;
    private Text outValue;
    final Type token = new TypeToken<Map<String, String>>(){}.getType();
    private Gson gson;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.gson = new Gson();
        this.outKey = new Text();
        this.outValue = new Text();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        for (Text json : values) {
            Map map = (Map)this.gson.fromJson(json.toString(), this.token);
            for (Map.Entry e : map.entrySet()) {
                this.outKey.set((String)e.getKey());
                this.outValue.set((String)e.getValue());
                context.write((Object)this.outKey, (Object)this.outValue);
            }
        }
    }
}

