/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.miscutils.maps.ConcurrentSizedMap;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

public class CoAuthorReducer
extends TableReducer<ImmutableBytesWritable, ImmutableBytesWritable, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(CoAuthorReducer.class);
    private static final boolean WRITE_TO_WAL = false;
    private static int MAX_COAUTHORS = 50;
    private int max_coauthors = MAX_COAUTHORS;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.max_coauthors = Integer.parseInt(context.getConfiguration().get("max.coauthors"));
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        byte[] keyBytes = key.copyBytes();
        final String rowKey = new String(keyBytes);
        log.info((Object)("Reducing key: '" + rowKey + "'"));
        Function<PersonProtos.Person, PersonProtos.Person.CoAuthor> personToCoAuthor = new Function<PersonProtos.Person, PersonProtos.Person.CoAuthor>(){

            public PersonProtos.Person.CoAuthor apply(PersonProtos.Person p) {
                PersonProtos.Person.CoAuthor.Builder cb = PersonProtos.Person.CoAuthor.newBuilder();
                cb.setId(CoAuthorReducer.this.getId(rowKey, p.getMetadata().getFullname().getValue().trim()));
                cb.getMetadataBuilder().mergeFrom(p.getMetadata());
                return cb.build();
            }
        };
        OafProtos.Oaf.Builder out = OafProtos.Oaf.newBuilder();
        ConcurrentSizedMap coAuthors = new ConcurrentSizedMap();
        coAuthors.setQueueSize(this.max_coauthors);
        block4: for (ImmutableBytesWritable ibw : values) {
            OafDecoder d = OafDecoder.decode((byte[])ibw.copyBytes());
            TypeProtos.Type type = d.getEntity().getType();
            switch (type) {
                case person: {
                    out.mergeFrom(d.getOaf());
                    out.getEntityBuilder().getPersonBuilder().clearCoauthor();
                    context.getCounter("coauthor", "merge").increment(1L);
                    break;
                }
                case result: {
                    List authorList = d.getEntity().getResult().getAuthorList();
                    for (PersonProtos.Person.CoAuthor coauthor : Lists.newArrayList((Iterable)Iterables.transform((Iterable)authorList, (Function)personToCoAuthor))) {
                        coAuthors.put((Object)coauthor.getId(), (Object)this.incrementCount((ConcurrentSizedMap<String, PersonProtos.Person.CoAuthor>)coAuthors, coauthor));
                    }
                    continue block4;
                }
                default: {
                    context.getCounter("coauthor", "skipped entity type (reduce)").increment(1L);
                }
            }
        }
        coAuthors.remove((Object)rowKey);
        out.getEntityBuilder().getPersonBuilder().addAllCoauthor((Iterable)coAuthors.values());
        Put put = new Put(keyBytes).add(Bytes.toBytes((String)TypeProtos.Type.person.toString()), Bytes.toBytes((String)"body"), out.build().toByteArray());
        put.setWriteToWAL(false);
        context.write((Object)key, (Object)put);
    }

    private PersonProtos.Person.CoAuthor incrementCount(ConcurrentSizedMap<String, PersonProtos.Person.CoAuthor> coAuthors, PersonProtos.Person.CoAuthor coauthor) {
        if (coAuthors.containsKey((Object)coauthor.getId())) {
            PersonProtos.Person.CoAuthor.Builder c = PersonProtos.Person.CoAuthor.newBuilder((PersonProtos.Person.CoAuthor)((PersonProtos.Person.CoAuthor)coAuthors.get((Object)coauthor.getId())));
            c.setCoauthoredpapers(c.getCoauthoredpapers() + 1);
            return c.build();
        }
        return coauthor;
    }

    private String getId(String resultId, String name) {
        String prefix = StringUtils.substringBefore((String)StringUtils.substringAfter((String)resultId, (String)"|"), (String)"::");
        String id = name.replaceAll("\\s+", " ").trim();
        return AbstractDNetOafXsltFunctions.oafId((String)TypeProtos.Type.person.toString(), (String)prefix, (String)id);
    }
}

