/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.gt;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class BuildMergedAnchorMapMapper
extends TableMapper<ImmutableBytesWritable, Text> {
    private ImmutableBytesWritable outKey;
    private Text outValue;
    final Type token = new TypeToken<Map<String, String>>(){}.getType();
    private Gson gson;

    protected void setup(Mapper.Context context) {
        this.outKey = new ImmutableBytesWritable(Bytes.toBytes((String)"1"));
        this.outValue = new Text();
        this.gson = new Gson();
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder rkd = OafRowKeyDecoder.decode((byte[])rowkey.copyBytes());
        if (!TypeProtos.Type.person.equals((Object)rkd.getType())) {
            context.getCounter(rkd.getType().toString(), "skipped").increment(1L);
        }
        byte[] body = value.getValue(Bytes.toBytes((String)TypeProtos.Type.person.toString()), DedupUtils.BODY_B);
        OafDecoder d = OafDecoder.decode((byte[])body);
        String anchorId = d.getEntity().getId();
        HashMap map = Maps.newHashMap();
        for (PersonProtos.Person.MergedPerson p : d.getEntity().getPerson().getMergedpersonList()) {
            map.put(p.getId(), anchorId);
        }
        this.outValue.set(this.gson.toJson((Object)map, this.token));
        context.write((Object)this.outKey, (Object)this.outValue);
    }
}

