package eu.dnetlib.data.mapreduce.hbase.actions;

import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;

public class DeleteActionsJob extends AbstractActionsJob {

	@Override
	protected Class<? extends TableMapper<ImmutableBytesWritable, ?>> getMapperClass() {
		return DeleteActionsMapper.class;
	}

	@Override
	protected Class<?> getMapOutputValueClass() {
		return Delete.class;
	}

	@Override
	protected void addSpecificFilters(FilterList filters) {
		// NOT necessary
	}

	@Override
	protected void addSpecificScanClauses(Scan scan) {
		// NOT necessary
	}
}