package eu.dnetlib.data.mapreduce.hbase.broker;

import java.io.IOException;

import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.FieldTypeProtos.KeyValue;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.PersonProtos.Person;

public class CalculatePersonDistributionMapper extends TableMapper<Text, ImmutableBytesWritable> {

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		super.setup(context);
	}

	@Override
	protected void map(final ImmutableBytesWritable key, final Result result, final Context context) throws IOException,
			InterruptedException {
		if (DedupUtils.isRoot(key)) { return; }

		final byte[] body = result.getValue(Bytes.toBytes("result"), Bytes.toBytes("body"));
		if (body == null) { return; }

		final Oaf oaf = Oaf.parseFrom(body);
		final eu.dnetlib.data.proto.ResultProtos.Result r = oaf.getEntity().getResult();
		if (r != null) {
			for (Person p : r.getAuthorList()) {
				final String name = p.getMetadata().getFullname().getValue();
				for (KeyValue kv : oaf.getEntity().getCollectedfromList()) {
					context.write(new Text(name), new ImmutableBytesWritable(Bytes.toBytes(kv.getKey())));
				}
			}
		}
	}
}
