/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.plugins.ftp.ClientProviderFactory;
import eu.dnetlib.data.collector.plugins.ftp.FtpClientProvider;
import eu.dnetlib.data.collector.plugins.ftp.ItemUtility;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;

public abstract class FtpDirectoryWalker<T> {
    private static final Log log = LogFactory.getLog(FtpDirectoryWalker.class);
    private final int depthLimit;
    private ItemUtility itemParam;
    protected FtpClientProvider clientProvider;
    private FTPFileFilter filter;

    protected FtpDirectoryWalker(ItemUtility itemParam) {
        this(null, 0, itemParam, "ftp");
    }

    protected FtpDirectoryWalker(FTPFileFilter filter, int depthLimit, ItemUtility itemParam, String protocol) {
        this.filter = filter;
        this.depthLimit = depthLimit;
        this.itemParam = itemParam;
        this.clientProvider = (FtpClientProvider)ClientProviderFactory.getProvider("ftp");
    }

    protected void handleStart(String startDirectory, Collection<T> results) throws IOException {
    }

    protected boolean handleDirectory(String directory, int depth, Collection<T> results) throws IOException {
        return true;
    }

    protected void handleDirectoryStart(String directory, int depth, Collection<T> results) throws IOException {
    }

    protected void handleFile(FTPFile file, int depth, Collection<T> results) throws IOException {
    }

    protected void handleEnd(Collection<T> results) throws IOException {
        this.clientProvider.disconnect();
    }

    public void initialize() {
        this.clientProvider.setItemParam(this.itemParam);
        this.clientProvider.connect();
        this.clientProvider.changeWorkingDirectory(this.itemParam.getBasePath());
    }

    protected final void walk(String startDirectory, Collection<T> results) throws IOException {
        if (startDirectory == null) {
            throw new NullPointerException("Start Directory is null");
        }
        this.handleStart(startDirectory, results);
        this.walk(startDirectory, -1, results);
        this.handleEnd(results);
    }

    private void walk(String directory, int depth, Collection<T> results) throws IOException {
        if (this.handleDirectory(directory, depth, results)) {
            FTPFile[] childFiles;
            String currentDirectory = this.clientProvider.printWorkingDirectory();
            this.clientProvider.changeWorkingDirectory(directory);
            int childDepth = depth + 1;
            if ((this.depthLimit < 0 || childDepth <= this.depthLimit) && (childFiles = this.clientProvider.listFiles()) != null) {
                for (FTPFile childFile : childFiles) {
                    if (childFile.isDirectory()) {
                        this.handleDirectoryStart(this.clientProvider.printWorkingDirectory() + "/" + childFile.getName(), childDepth, results);
                        this.walk(this.clientProvider.printWorkingDirectory() + "/" + childFile.getName(), childDepth, results);
                        this.clientProvider.changeWorkingDirectory(currentDirectory);
                        continue;
                    }
                    if (this.filter != null && !this.filter.accept(childFile)) continue;
                    log.info((Object)("Take the File " + childFile.getName()));
                    this.handleFile(childFile, childDepth, results);
                }
            }
            this.handleDirectoryEnd(directory, depth, results);
        }
    }

    protected String getCurrentDirectory() throws IOException {
        return this.clientProvider.printWorkingDirectory();
    }

    protected void handleDirectoryEnd(String directory, int depth, Collection<T> results) throws IOException {
    }

    protected String getFileFrom(String remote) throws IOException {
        return this.clientProvider.retrieveFileStream(remote);
    }

    protected void completePendingCommand() throws IOException {
        this.clientProvider.completePendingCommand();
    }
}

