package eu.dnetlib.data.collector.plugins.ftp;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * BlockingStream fetches elements from a shared queue, which must be populated by a producer.
 * 
 * @author andrea
 * 
 * @param <T>
 *            Type returned by the next() method
 */
public class FtpBlockingStream<T> implements Iterator<T> {

	/**
	 * Logger.
	 */
	private static final Log log = LogFactory.getLog(FtpBlockingStream.class);

	/**
	 * shared queue.
	 */
	private BlockingQueue<T> queue;

	/**
	 * next element to be returned.
	 */
	private T nextReturn;

	/**
	 * flag.
	 */
	private boolean hasNext = true;

	/**
	 * Builds a BlockingStream.
	 * 
	 * @param queue
	 *            the shared queue.
	 */
	public FtpBlockingStream(final BlockingQueue<T> queue) {
		super();
		this.queue = queue;
	}

	@Override
	synchronized public boolean hasNext() {

		while (nextReturn == null) {

			try {
				nextReturn = queue.poll(2, TimeUnit.SECONDS);
			} catch (InterruptedException e) {
				log.error("queue timed out ", e);
				return false;
			}

			if ((FtpIterable.done == nextReturn)) {
				hasNext = false;
			}
		}
		return hasNext;
	}

	@Override
	synchronized public T next() {
		if (!hasNext()) throw new NoSuchElementException();

		T retVal = nextReturn;
		nextReturn = null;
		return retVal;
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException("Not available.");
	}

}
