/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(FilesystemIterable.class);
    private File baseDir;
    private String[] extensions;

    public FilesystemIterable(InterfaceDescriptor descriptor) throws CollectorServiceException {
        try {
            String baseUrl = descriptor.getBaseUrl();
            URL basePath = new URL(baseUrl);
            this.baseDir = new File(basePath.getPath());
            if (!this.baseDir.exists()) {
                throw new CollectorServiceException(String.format("The base ULR %s, does not exist", basePath.getPath()));
            }
            this.extensions = (String[])Iterables.toArray((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)descriptor.getParams().get("extensions")), String.class);
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException("Filesystem collector failed! ", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Iterators.transform((Iterator)FileUtils.iterateFiles((File)this.baseDir, (String[])this.extensions, (boolean)true), (Function)new Function<File, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String apply(File input) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(input);
                    String s = IOUtils.toString((InputStream)fileInputStream);
                    String string = s.startsWith("\ufeff") ? s.substring(1) : s;
                    return string;
                }
                catch (Exception e) {
                    log.error((Object)("Unable to read " + input.getPath()));
                    String string = null;
                    return string;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException e) {
                            log.error((Object)("Unable to close inputstream for  " + input.getPath()));
                        }
                    }
                }
            }
        });
    }
}

