/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.plugins.ftp.FtpIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FtpBlockingStream<T>
implements Iterator<T> {
    private static final Log log = LogFactory.getLog(FtpBlockingStream.class);
    private BlockingQueue<T> queue;
    private T nextReturn;
    private boolean hasNext = true;

    public FtpBlockingStream(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    @Override
    public synchronized boolean hasNext() {
        while (this.nextReturn == null) {
            try {
                this.nextReturn = this.queue.poll(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error((Object)"queue timed out ", (Throwable)e);
                return false;
            }
            if (FtpIterable.done != this.nextReturn) continue;
            this.hasNext = false;
        }
        return this.hasNext;
    }

    @Override
    public synchronized T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T retVal = this.nextReturn;
        this.nextReturn = null;
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not available.");
    }
}

