/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.plugins.ftp.FtpBlockingStream;
import eu.dnetlib.data.collector.plugins.ftp.FtpFileWalker;
import eu.dnetlib.data.collector.plugins.ftp.ItemUtility;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FtpIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(FtpIterable.class);
    private final boolean recursive;
    private final ItemUtility itemParam;
    private final BlockingQueue<String> queue;
    private ExecutorService producer;
    public static final Object done = new Object();

    public FtpIterable(InterfaceDescriptor descriptor) throws URISyntaxException {
        this.recursive = Boolean.parseBoolean((String)descriptor.getParams().get("recursive"));
        this.itemParam = new ItemUtility(descriptor);
        this.producer = Executors.newSingleThreadExecutor();
        this.queue = new ArrayBlockingQueue<String>(20);
    }

    @Override
    public Iterator<String> iterator() {
        this.doReadFromFTP();
        return new FtpBlockingStream<String>(this.queue);
    }

    private void doReadFromFTP() {
        final FtpFileWalker<String> walker = new FtpFileWalker<String>(this.queue, null, this.recursive ? 0 : -1, this.itemParam, "ftp");
        this.producer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    walker.doWalk(FtpIterable.this.itemParam.getBasePath());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                log.info((Object)("finished to iterate under " + FtpIterable.this.itemParam.getBasePath()));
            }
        });
    }
}

