/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.ftp.FtpIterable;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FtpCollectorPlugin
implements CollectorPlugin {
    private static final Log log = LogFactory.getLog(FtpCollectorPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String username = (String)interfaceDescriptor.getParams().get("username");
        String password = (String)interfaceDescriptor.getParams().get("password");
        String filter = (String)interfaceDescriptor.getParams().get("filter");
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new CollectorServiceException("Param 'username' is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new CollectorServiceException("Param 'password' is null or empty");
        }
        if (filter == null || filter.isEmpty()) {
            throw new CollectorServiceException("Param 'filter' is null or empty");
        }
        try {
            return new FtpIterable(interfaceDescriptor);
        }
        catch (URISyntaxException e) {
            log.error((Object)"Ftp collector plugin failed", (Throwable)e);
            return null;
        }
    }

    public String getProtocol() {
        return "ftp";
    }

    public List<String> listNameParameters() {
        return Lists.newArrayList((Object[])new String[]{"username", "password", "filter", "recursive"});
    }
}

