/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HttpCSVCollectorPlugin
implements CollectorPlugin {
    public Iterable<String> collect(InterfaceDescriptor descriptor, String fromDate, String untilDate) throws CollectorServiceException {
        return new HTTPCSVIterator(descriptor);
    }

    public String getProtocol() {
        return "httpCSV";
    }

    public List<String> listNameParameters() {
        return Lists.newArrayList((Object[])new String[]{"separator", "identifier", "quote"});
    }

    class HTTPCSVIterator
    implements Iterable<String> {
        private InterfaceDescriptor descriptor;

        public HTTPCSVIterator(InterfaceDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public Iterator<String> iterator() {
            try {
                String separator = (String)this.descriptor.getParams().get("separator");
                final String identifier = (String)this.descriptor.getParams().get("identifier");
                String quote = (String)this.descriptor.getParams().get("quote");
                URL url = new URL(this.descriptor.getBaseUrl());
                url.openConnection();
                InputStreamReader reader = new InputStreamReader(url.openStream());
                CSVFormat format = CSVFormat.EXCEL.withHeader(new String[0]).withDelimiter(separator.charAt(0)).withQuote(quote.charAt(0));
                CSVParser parser = new CSVParser((Reader)reader, format);
                final Set headers = parser.getHeaderMap().keySet();
                Function<CSVRecord, String> function = new Function<CSVRecord, String>(){

                    public String apply(CSVRecord input) {
                        Document document = DocumentHelper.createDocument();
                        Element root = document.addElement("csvRecord");
                        for (String key : headers) {
                            Element row = root.addElement("column");
                            row.addAttribute("name", key).addText(input.get(key));
                            if (!key.equals(identifier)) continue;
                            row.addAttribute("isID", "true");
                        }
                        return document.asXML();
                    }
                };
                Iterator result = Iterators.transform((Iterator)parser.iterator(), (Function)function);
                return result;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

