/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp2;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.ftp2.FtpIteratorFactory;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

public class Ftp2CollectorPlugin
implements CollectorPlugin {
    private FtpIteratorFactory ftpIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        final String username = (String)interfaceDescriptor.getParams().get("username");
        final String password = (String)interfaceDescriptor.getParams().get("password");
        final String recursive = (String)interfaceDescriptor.getParams().get("recursive");
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new CollectorServiceException("Param 'username' is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new CollectorServiceException("Param 'password' is null or empty");
        }
        if (recursive == null || recursive.isEmpty()) {
            throw new CollectorServiceException("Param 'recursive' is null or empty");
        }
        return new Iterable<String>(){
            boolean isRecursive;
            {
                this.isRecursive = "true".equals(recursive);
            }

            @Override
            public Iterator<String> iterator() {
                return Ftp2CollectorPlugin.this.getFtpIteratorFactory().newIterator(baseUrl, username, password, this.isRecursive);
            }
        };
    }

    public String getProtocol() {
        return "ftp2";
    }

    public List<String> listNameParameters() {
        return Lists.newArrayList((Object[])new String[]{"username", "password", "recursive"});
    }

    public FtpIteratorFactory getFtpIteratorFactory() {
        return this.ftpIteratorFactory;
    }

    @Required
    public void setFtpIteratorFactory(FtpIteratorFactory ftpIteratorFactory) {
        this.ftpIteratorFactory = ftpIteratorFactory;
    }
}

