/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oaisets;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.oaisets.OaiSetsIteratorFactory;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

public class OaiSetsCollectorPlugin
implements CollectorPlugin {
    private OaiSetsIteratorFactory oaiSetsIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return OaiSetsCollectorPlugin.this.oaiSetsIteratorFactory.newIterator(baseUrl);
            }
        };
    }

    public String getProtocol() {
        return "oai_sets";
    }

    public List<String> listNameParameters() {
        return Lists.newArrayList();
    }

    public OaiSetsIteratorFactory getOaiSetsIteratorFactory() {
        return this.oaiSetsIteratorFactory;
    }

    @Required
    public void setOaiSetsIteratorFactory(OaiSetsIteratorFactory oaiSetsIteratorFactory) {
        this.oaiSetsIteratorFactory = oaiSetsIteratorFactory;
    }
}

