package eu.dnetlib.data.collector.plugins.ftp;

import java.net.URISyntaxException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

/**
 * 
 * @author andrea
 * 
 */
public class FtpCollectorPlugin implements CollectorPlugin {

	private static final Log log = LogFactory.getLog(FtpCollectorPlugin.class);

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate) throws CollectorServiceException {

		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String username = interfaceDescriptor.getParams().get("username");
		final String password = interfaceDescriptor.getParams().get("password");
		final String filter = interfaceDescriptor.getParams().get("filter");

		if ((baseUrl == null) || baseUrl.isEmpty()) throw new CollectorServiceException("Param 'baseurl' is null or empty");
		if ((username == null) || username.isEmpty()) throw new CollectorServiceException("Param 'username' is null or empty");
		if ((password == null) || password.isEmpty()) throw new CollectorServiceException("Param 'password' is null or empty");
		if ((filter == null) || filter.isEmpty()) throw new CollectorServiceException("Param 'filter' is null or empty");

		try {
			return new FtpIterable(interfaceDescriptor);
		} catch (URISyntaxException e) {
			log.error("Ftp collector plugin failed", e);
			return null;
		}
	}

	@Override
	public String getProtocol() {
		return "ftp";
	}

	@Override
	public List<String> listNameParameters() {
		return Lists.newArrayList("username", "password", "filter", "recursive");
	}

}
