/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(FilesystemIterable.class);
    private File baseDir;
    private String filter;

    public FilesystemIterable(InterfaceDescriptor descriptor) throws CollectorServiceException {
        try {
            String baseUrl = descriptor.getBaseUrl();
            URL basePath = new URL(baseUrl);
            this.baseDir = new File(basePath.getPath());
            if (!this.baseDir.exists()) {
                throw new CollectorServiceException(String.format("The base ULR %s, does not exist", basePath.getPath()));
            }
            this.filter = (String)descriptor.getParams().get("extensions");
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException("Filesystem collector failed! ", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        try {
            DirectoryStream<Path> directoryStreams = null;
            directoryStreams = StringUtils.isBlank((String)this.filter) ? Files.newDirectoryStream(Paths.get(this.baseDir.getAbsolutePath(), new String[0]), this.filter) : Files.newDirectoryStream(Paths.get(this.baseDir.getAbsolutePath(), new String[0]));
            return Iterators.transform(directoryStreams.iterator(), (Function)new Function<Path, String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String apply(Path input) {
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(input.toString());
                        String s = IOUtils.toString((InputStream)fileInputStream);
                        String string = XmlCleaner.cleanAllEntities(s.startsWith("\ufeff") ? s.substring(1) : s);
                        return string;
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to read " + input.toString()));
                        String string = null;
                        return string;
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException e) {
                                log.error((Object)("Unable to close inputstream for  " + input.toString()));
                            }
                        }
                    }
                }
            });
        }
        catch (IOException e1) {
            log.error((Object)e1);
            return null;
        }
    }
}

