/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;

public class ItemUtility {
    private String username;
    private String password;
    private String host;
    private String basePath;
    private String controllerURL;
    private String protocol;

    public ItemUtility() {
    }

    public ItemUtility(InterfaceDescriptor descriptor) {
        URI source = null;
        try {
            source = new URI(descriptor.getBaseUrl());
        }
        catch (URISyntaxException e) {
            return;
        }
        this.setHost(source.getHost());
        this.setBasePath(source.getPath());
        this.protocol = source.getScheme();
        this.username = (String)descriptor.getParams().get("username");
        this.password = (String)descriptor.getParams().get("password");
    }

    public String getUsername() {
        return this.username;
    }

    public ItemUtility setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ItemUtility setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ItemUtility setHost(String host) {
        this.host = host;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ItemUtility setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getControllerURL() {
        return this.controllerURL;
    }

    public ItemUtility setControllerURL(String controllerURL) {
        this.controllerURL = controllerURL;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ItemUtility setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String generateURLEncoded(String absolutePath) throws UnsupportedEncodingException {
        URI uri = URI.create(absolutePath);
        StringBuilder sb = this.serialize(uri);
        byte[] miaEnc = Base64.encodeBase64((byte[])sb.toString().getBytes());
        return this.controllerURL + "?var=" + URLEncoder.encode(new String(miaEnc), "UTF-8");
    }

    public String toString() {
        return this.serialize(URI.create(this.getProtocol() + "://" + this.getHost() + this.getBasePath())).toString();
    }

    private StringBuilder serialize(URI uri) {
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme() + "://");
        if (this.username != null && this.password != null) {
            sb.append(this.username);
            sb.append(":");
            sb.append(this.password);
            sb.append("@");
        }
        sb.append(uri.getHost());
        sb.append(uri.getPath());
        return sb;
    }
}

