/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp2;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(FtpIterator.class);
    private static final int MAX_RETRIES = 5;
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final long BACKOFF_MILLIS = 10000L;
    private FTPClient ftpClient;
    private String ftpServer;
    private String remoteBasePath;
    private int port;
    private String username;
    private String password;
    private boolean isRecursive;
    private Queue<String> queue;

    public FtpIterator(String baseUrl, int port, String username, String password, boolean isRecursive) {
        this.port = port;
        this.username = username;
        this.password = password;
        this.isRecursive = isRecursive;
        try {
            URL server = new URL(baseUrl);
            this.ftpServer = server.getHost();
            this.remoteBasePath = server.getPath();
        }
        catch (MalformedURLException e1) {
            throw new RuntimeException("Malformed URL exception" + baseUrl);
        }
        try {
            this.initializeQueue();
        }
        catch (Exception e) {
            log.error((Object)("Error in initializing FTP iterator: " + e.getMessage()), (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void initializeQueue() throws SocketException, IOException {
        this.ftpClient = new FTPClient();
        this.ftpClient.setDefaultTimeout(30000);
        this.queue = new LinkedList<String>();
        this.ftpClient.setDataTimeout(30000);
        this.ftpClient.setConnectTimeout(30000);
        this.ftpClient.connect(this.ftpServer, this.port);
        if (!this.checkPositiveResponse()) {
            this.ftpClient.disconnect();
            throw new IllegalStateException("Unable to connect to ftp server. " + this.ftpServer);
        }
        if (!this.ftpClient.login(this.username, this.password)) {
            this.ftpClient.logout();
            throw new IllegalStateException("Unable to login to ftp server. " + this.ftpServer);
        }
        this.ftpClient.enterLocalPassiveMode();
        this.listDirectoryRecursive(this.ftpClient, this.remoteBasePath, "");
    }

    private void listDirectoryRecursive(FTPClient ftpClient, String parentDir, String currentDir) {
        String dirToList = parentDir;
        if (!currentDir.equals("")) {
            dirToList = dirToList + "/" + currentDir;
        }
        try {
            FTPFile[] subFiles = ftpClient.listFiles(dirToList);
            if (subFiles != null && subFiles.length > 0) {
                for (FTPFile aFile : subFiles) {
                    String currentFileName = aFile.getName();
                    if (currentFileName.equals(".") || currentFileName.equals("..")) continue;
                    if (aFile.isDirectory()) {
                        if (!this.isRecursive) continue;
                        this.listDirectoryRecursive(ftpClient, dirToList, currentFileName);
                        continue;
                    }
                    this.queue.add(dirToList + "/" + currentFileName);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to list FTP folder tree", e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            try {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
                return false;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to logout & close FTP connection", e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        String path = this.queue.remove();
        int nRepeat = 0;
        while (nRepeat < 5) {
            InputStream retrievedFileStream;
            block20: {
                retrievedFileStream = null;
                retrievedFileStream = this.ftpClient.retrieveFileStream(path);
                if (!this.checkPositiveResponse()) {
                    throw new IllegalStateException("Unable to retrieve stream from ftp server. " + this.ftpServer + path);
                }
                if (retrievedFileStream == null) break block20;
                log.info((Object)("Collected file from FTP: " + this.ftpServer + path));
                String string = IOUtils.toString((InputStream)retrievedFileStream);
                try {
                    if (retrievedFileStream != null) {
                        IOUtils.closeQuietly((InputStream)retrievedFileStream);
                    }
                    if (!this.ftpClient.completePendingCommand()) {
                        throw new IllegalStateException("unable to complete pending command on ftp server. " + this.ftpServer);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Cannot execute ftpClient.completePendingCommand");
                }
                return string;
            }
            try {
                try {
                    throw new IllegalStateException("File retrieved from " + path + " is NULL");
                }
                catch (IOException e) {
                    log.info((Object)("An error occurred for " + this.ftpServer + path + ", retrying.. [retried {n} time(s)]".replace("{n}", String.valueOf(++nRepeat))));
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        if (retrievedFileStream != null) {
                            IOUtils.closeQuietly((InputStream)retrievedFileStream);
                        }
                        if (this.ftpClient.completePendingCommand()) continue;
                        throw new IllegalStateException("unable to complete pending command on ftp server. " + this.ftpServer);
                    }
                    catch (IOException e2) {
                        log.error((Object)"Cannot execute ftpClient.completePendingCommand");
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (retrievedFileStream != null) {
                        IOUtils.closeQuietly((InputStream)retrievedFileStream);
                    }
                    if (!this.ftpClient.completePendingCommand()) {
                        throw new IllegalStateException("unable to complete pending command on ftp server. " + this.ftpServer);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Cannot execute ftpClient.completePendingCommand");
                }
                throw throwable;
            }
        }
        throw new IllegalStateException("Impossible to retrieve FTP file " + path + " after " + nRepeat + " retries. Aborting FTP collection.");
    }

    @Override
    public void remove() {
    }

    private boolean checkPositiveResponse() throws IOException {
        int reply = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply) & !FTPReply.isPositivePreliminary((int)reply) & !FTPReply.isPositiveIntermediate((int)reply)) {
            this.ftpClient.disconnect();
            log.error((Object)("FTP server refused connection. " + this.ftpServer));
            throw new RuntimeException("FTP server refused connection. " + this.ftpServer);
        }
        return true;
    }
}

