/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oai;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.oai.OaiIteratorFactory;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

public class OaiCollectorPlugin
implements CollectorPlugin {
    private static final String FORMAT_PARAM = "format";
    private static final String OAI_SET_PARAM = "set";
    private OaiIteratorFactory oaiIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        final String mdFormat = (String)interfaceDescriptor.getParams().get(FORMAT_PARAM);
        String setParam = (String)interfaceDescriptor.getParams().get(OAI_SET_PARAM);
        final ArrayList sets = Lists.newArrayList();
        if (setParam != null) {
            sets.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)setParam)));
        }
        if (sets.isEmpty()) {
            sets.add("");
        }
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (mdFormat == null || mdFormat.isEmpty()) {
            throw new CollectorServiceException("Param 'mdFormat' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        if (untilDate != null && !untilDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + untilDate);
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                Iterable iter = Iterables.transform((Iterable)sets, (Function)new Function<String, Iterator<String>>(){

                    public Iterator<String> apply(String set) {
                        return OaiCollectorPlugin.this.oaiIteratorFactory.newIterator(baseUrl, mdFormat, set, fromDate, untilDate);
                    }
                });
                return Iterators.concat((Iterator[])((Iterator[])Iterables.toArray((Iterable)iter, Iterator.class)));
            }
        };
    }

    public String getProtocol() {
        return "OAI";
    }

    public OaiIteratorFactory getOaiIteratorFactory() {
        return this.oaiIteratorFactory;
    }

    @Required
    public void setOaiIteratorFactory(OaiIteratorFactory oaiIteratorFactory) {
        this.oaiIteratorFactory = oaiIteratorFactory;
    }

    public List<String> listNameParameters() {
        return Lists.newArrayList((Object[])new String[]{OAI_SET_PARAM, FORMAT_PARAM});
    }
}

