package eu.dnetlib.data.collector.plugins.ftp;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;

import org.apache.commons.codec.binary.Base64;

import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

/**
 * Utility class for the generation of the Linked resultset
 */
public class ItemUtility {

	/** The username. */
	private String username;

	/** The password. */
	private String password;

	/** The host. */
	private String host;

	/** The base path. */
	private String basePath;

	/** The controller url. */
	private String controllerURL;

	private String protocol;

	public ItemUtility() {}

	public ItemUtility(final InterfaceDescriptor descriptor) {

		URI source = null;
		try {
			source = new URI(descriptor.getBaseUrl());
		} catch (URISyntaxException e) {
			return;
		}
		this.setHost(source.getHost());
		this.setBasePath(source.getPath());
		this.protocol = source.getScheme();
		this.username = descriptor.getParams().get("username");
		this.password = descriptor.getParams().get("password");

	}

	/**
	 * Gets the username.
	 * 
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * Sets the username.
	 * 
	 * @param username
	 *            the new username
	 */
	public ItemUtility setUsername(final String username) {
		this.username = username;
		return this;
	}

	/**
	 * Gets the password.
	 * 
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * Sets the password.
	 * 
	 * @param password
	 *            the new password
	 */
	public ItemUtility setPassword(final String password) {
		this.password = password;
		return this;
	}

	/**
	 * Gets the host.
	 * 
	 * @return the host
	 */
	public String getHost() {
		return host;
	}

	/**
	 * Sets the host.
	 * 
	 * @param host
	 *            the new host
	 */
	public ItemUtility setHost(final String host) {
		this.host = host;
		return this;
	}

	/**
	 * Gets the base path.
	 * 
	 * @return the base path
	 */
	public String getBasePath() {
		return basePath;
	}

	/**
	 * Sets the base path.
	 * 
	 * @param basePath
	 *            the new base path
	 */
	public ItemUtility setBasePath(final String basePath) {
		this.basePath = basePath;
		return this;
	}

	/**
	 * Gets the controller url.
	 * 
	 * @return the controller url
	 */
	public String getControllerURL() {
		return controllerURL;
	}

	/**
	 * Sets the controller url.
	 * 
	 * @param controllerURL
	 *            the new controller url
	 */
	public ItemUtility setControllerURL(final String controllerURL) {
		this.controllerURL = controllerURL;
		return this;
	}

	public String getProtocol() {
		return protocol;
	}

	public ItemUtility setProtocol(final String protocol) {
		this.protocol = protocol;
		return this;
	}

	/**
	 * Generate url encodec.
	 * 
	 * @param absolutePath
	 *            the relative path
	 * @return the string
	 * @throws UnsupportedEncodingException
	 *             the unsupported encoding exception
	 */
	public String generateURLEncoded(final String absolutePath) throws UnsupportedEncodingException {
		URI uri = URI.create(absolutePath);

		StringBuilder sb = serialize(uri);

		byte[] miaEnc = Base64.encodeBase64(sb.toString().getBytes());
		return controllerURL + "?var=" + URLEncoder.encode(new String(miaEnc), "UTF-8");
	}

	@Override
	public String toString() {
		return serialize(URI.create(getProtocol() + "://" + getHost() + getBasePath())).toString();
	}

	private StringBuilder serialize(final URI uri) {
		StringBuilder sb = new StringBuilder();
		sb.append(uri.getScheme() + "://");
		if ((username != null) && (password != null)) {
			sb.append(username);
			sb.append(":");
			sb.append(password);
			sb.append("@");
		}
		sb.append(uri.getHost());
		sb.append(uri.getPath());

		return sb;
	}

}
