package eu.dnetlib.data.collector.plugins.ftp2;

import java.util.Iterator;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import com.google.common.collect.Lists;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

/**
 * 
 * @author andrea
 * 
 */
public class Ftp2CollectorPlugin implements CollectorPlugin {

	private FtpIteratorFactory ftpIteratorFactory;

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate) throws CollectorServiceException {
		
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String username = interfaceDescriptor.getParams().get("username");
		final String password = interfaceDescriptor.getParams().get("password");
		final String recursive = interfaceDescriptor.getParams().get("recursive");

		if ((baseUrl == null) || baseUrl.isEmpty()) throw new CollectorServiceException("Param 'baseurl' is null or empty");
		if ((username == null) || username.isEmpty()) throw new CollectorServiceException("Param 'username' is null or empty");
		if ((password == null) || password.isEmpty()) throw new CollectorServiceException("Param 'password' is null or empty");
		if ((recursive == null) || recursive.isEmpty()) throw new CollectorServiceException("Param 'recursive' is null or empty");

		return new Iterable<String>() {
			boolean isRecursive = ("true".equals(recursive) ? true : false);
			@Override
			public Iterator<String> iterator() {
				return getFtpIteratorFactory().newIterator(baseUrl, username, password, isRecursive);
			}
		};
	}

	@Override
	public String getProtocol() {
		return "ftp2";
	}

	@Override
	public List<String> listNameParameters() {
		return Lists.newArrayList("username", "password", "recursive");
	}

	public FtpIteratorFactory getFtpIteratorFactory() {
		return ftpIteratorFactory;
	}

	@Required
	public void setFtpIteratorFactory(FtpIteratorFactory ftpIteratorFactory) {
		this.ftpIteratorFactory = ftpIteratorFactory;
	}

}
