package eu.dnetlib.data.collector.plugins.filesystem;

import java.util.List;

import com.google.common.collect.Lists;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

/**
 * 
 * @author andrea
 * 
 */
public class FilesystemCollectorPlugin implements CollectorPlugin {

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {

		final String baseUrl = interfaceDescriptor.getBaseUrl();
		if ((baseUrl == null) || baseUrl.isEmpty()) throw new CollectorServiceException("Param 'baseurl' is null or empty");
		return new FilesystemIterable(interfaceDescriptor);

	}

	@Override
	public String getProtocol() {
		return "filesystem";
	}

	@Override
	public List<String> listNameParameters() {
		return Lists.newArrayList("extensions");
	}
}
