package eu.dnetlib.data.collector.plugins.ftp;

import java.io.IOException;

import org.apache.commons.net.ftp.FTPFile;

/**
 * The Interface FTPClientProvider.
 */
public interface FtpClientProvider extends IClientProvider {

	/**
	 * List files.
	 * 
	 * @return the fTP file[]
	 */
	FTPFile[] listFiles();

	/**
	 * List files.
	 * 
	 * @param source
	 *            the source
	 * @return the fTP file[]
	 */
	FTPFile[] listFiles(String source);

	// Navigation Method
	/**
	 * Change working directory.
	 * 
	 * @param path
	 *            the path
	 * @return true, if successful
	 */
	boolean changeWorkingDirectory(String path);

	/**
	 * Prints the working directory.
	 * 
	 * @return the string
	 */
	String printWorkingDirectory();

	/**
	 * Complete pending command.
	 * 
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	void completePendingCommand() throws IOException;

}
