package eu.dnetlib.functionality.modular.ui.lightui.clients;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.lightui.menu.LightUiMenuEntry;

public class ISLookupClient {

	@Resource
	private UniqueServiceLocator serviceLocator;

	private static final Log log = LogFactory.getLog(ISLookupClient.class);

	public List<LightUiMenuEntry> listMenuEntries() {
		final String xQuery = "for $x in collection('/db/DRIVER/LightUiDSResources/LightUiDSResourceType') order by $x//UI_NAME "
				+ "return concat ($x//UI_NAME/@id, '§§§', $x//UI_NAME, '§§§', $x//UI_DESCRIPTION)";
		List<LightUiMenuEntry> result = new ArrayList<LightUiMenuEntry>();
		try {
			List<String> uiProfiles = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xQuery);
			int i = 1;
			for (String profile : uiProfiles) {
				String[] tokens = profile.split("§§§");
				result.add(new LightUiMenuEntry(tokens[0].trim(), tokens[1].trim(), tokens[1].trim(), tokens[2].trim(), i++));
			}
			return result;
		} catch (ISLookUpException e) {
			log.error("Error calculating lightui menu entries", e);
			return result;
		}
	}

	public String getLightUiProfile(final String lightuiId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
		String xQuery = "for $x in collection('/db/DRIVER/LightUiDSResources/LightUiDSResourceType') where $x//UI_NAME/@id = '{id}' return $x";
		return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery.replace("{id}", lightuiId));
	}

}
