package eu.dnetlib.functionality.modular.ui.lightui;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;

import com.google.gson.Gson;

import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.lightui.objects.SearchField;
import eu.dnetlib.functionality.modular.ui.lightui.objects.SearchFieldGrouper;

public class LightUiEntryPointController extends ModuleEntryPoint {
	
	private SearchFieldGrouper searchFieldGrouper;

	@Override
	protected void initialize(final ModelMap map, final HttpServletRequest request,
			final HttpServletResponse response) throws Exception {
		
		if (request.getParameterMap().containsKey("ui")) {
			final String uiId = request.getParameter("ui");
			final List<SearchField> searchFields = searchFieldGrouper.getAllFields(uiId);
			map.addAttribute("fields", searchFields);
			map.addAttribute("fieldsJson", (new Gson()).toJson(searchFields));
			map.addAttribute("uiId", uiId);
		} else {
			response.sendError(500, "Field 'ui' is missing");
		}
	}

	public SearchFieldGrouper getSearchFieldGrouper() {
		return searchFieldGrouper;
	}

	@Required
	public void setSearchFieldGrouper(SearchFieldGrouper searchFieldGrouper) {
		this.searchFieldGrouper = searchFieldGrouper;
	}

}
