/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.enabling.datasources.DatasourceFunctions;
import eu.dnetlib.enabling.datasources.DatasourceManagerClients;
import eu.dnetlib.enabling.datasources.DatasourceParams;
import eu.dnetlib.enabling.datasources.DbBrowsableField;
import eu.dnetlib.enabling.datasources.rmi.BrowsableField;
import eu.dnetlib.enabling.datasources.rmi.BrowseTerm;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.datasources.rmi.RepositoryMapEntry;
import eu.dnetlib.enabling.datasources.rmi.SearchInterfacesEntry;
import eu.dnetlib.enabling.datasources.rmi.SimpleDatasourceDesc;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class DatasourceManagerServiceImpl
extends AbstractBaseService
implements DatasourceManagerService {
    private DatasourceManagerClients datasourceManagerClients;
    private List<DbBrowsableField> browsableFields;
    private static final Log log = LogFactory.getLog(DatasourceManagerServiceImpl.class);

    public boolean addDatasource(DatasourceDesc ds) throws DatasourceManagerServiceException {
        if (StringUtils.isBlank((String)ds.getAggregator())) {
            ds.setAggregator("OPENAIRE");
        }
        Map<String, Object> params = DatasourceFunctions.asMapOfSqlValues(ds);
        if (ds.getOrganization() != null && !ds.getOrganization().trim().isEmpty()) {
            params.put("hasOrganization", 1);
        }
        return this.datasourceManagerClients.updateSQL(ds.getId(), "addDatasource.sql.st", params, false, true);
    }

    public boolean deleteDatasource(String dsId) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        return this.datasourceManagerClients.updateSQL(dsId, "deleteDatasource.sql.st", params, true, true);
    }

    public DatasourceDesc getDatasource(String dsId) throws DatasourceManagerServiceException {
        List<DatasourceDesc> list = this.datasourceManagerClients.getDatasourcesByCondition("ds.id = " + DatasourceFunctions.asSqlValue(dsId));
        if (list.size() != 1) {
            throw new DatasourceManagerServiceException("Datasource not found, id=" + dsId);
        }
        return list.get(0);
    }

    public List<DatasourceDesc> listAllDatasources() throws DatasourceManagerServiceException {
        return this.datasourceManagerClients.getDatasourcesByCondition(null);
    }

    public List<DatasourceDesc> listDatasourcesUsingFilter(String compliance, String contentDescription, String iisProcessingWorkflow, String collectedFrom) throws DatasourceManagerServiceException {
        String cond = "";
        if (compliance != null && !compliance.isEmpty()) {
            if (!cond.isEmpty()) {
                cond = cond + " and ";
            }
            cond = cond + "ag.compatibilityclass=" + DatasourceFunctions.asSqlValue(compliance);
        }
        if (contentDescription != null && !contentDescription.isEmpty()) {
            if (!cond.isEmpty()) {
                cond = cond + " and ";
            }
            cond = cond + "ag.contentdescriptionclass=" + DatasourceFunctions.asSqlValue(contentDescription);
        }
        if (iisProcessingWorkflow != null && !iisProcessingWorkflow.isEmpty()) {
            if (!cond.isEmpty()) {
                cond = cond + " and ";
            }
            cond = cond + "ag.accessinfopackage LIKE '%###" + (Object)((Object)DatasourceParams.iis_processing_workflow) + "###" + iisProcessingWorkflow + "###%'";
        }
        if (collectedFrom != null && !collectedFrom.isEmpty()) {
            if (!cond.isEmpty()) {
                cond = cond + " and ";
            }
            cond = cond + "ds.collectedfrom=" + DatasourceFunctions.asSqlValue(collectedFrom);
        }
        return this.datasourceManagerClients.getDatasourcesByCondition(cond);
    }

    public boolean updateActivationStatus(String dsId, String ifaceId, boolean active) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("active", DatasourceFunctions.asSqlValue(active));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        return this.datasourceManagerClients.updateSQL(dsId, "updateActivationStatus.sql.st", params, false, true);
    }

    public boolean updateLevelOfCompliance(String dsId, String ifaceId, String level) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("level", DatasourceFunctions.asSqlValue(level));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        return this.datasourceManagerClients.updateSQL(dsId, "updateLevelOfCompliance.sql.st", params, false, true);
    }

    public boolean updateBaseUrl(String dsId, String ifaceId, String baseUrl) throws DatasourceManagerServiceException {
        return this.updateAccessParam(dsId, ifaceId, DatasourceParams.baseUrl.toString(), baseUrl, true);
    }

    public boolean updateContentDescription(String dsId, String ifaceId, String desc) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("desc", DatasourceFunctions.asSqlValue(desc));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        return this.datasourceManagerClients.updateSQL(dsId, "updateContentDescription.sql.st", params, false, true);
    }

    public boolean setIisProcessingWorkflow(String dsId, String ifaceId, String wf) throws DatasourceManagerServiceException {
        return this.updateExtraField(dsId, ifaceId, DatasourceParams.iis_processing_workflow.toString(), wf, false);
    }

    public boolean addInterface(String dsId, IfaceDesc iface) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("datasource", DatasourceFunctions.asSqlValue(dsId));
        params.put("id", DatasourceFunctions.asSqlValue(iface.getId()));
        params.put("typology", DatasourceFunctions.asSqlValue(iface.getTypology()));
        params.put("protocol", DatasourceFunctions.asSqlValue(iface.getAccessProtocol()));
        params.put("baseUrl", DatasourceFunctions.asSqlValue(iface.getBaseUrl()));
        params.put("description", DatasourceFunctions.asSqlValue(iface.getContentDescription()));
        params.put("compliance", DatasourceFunctions.asSqlValue(iface.getCompliance()));
        HashMap<String, String> accessParams = new HashMap<String, String>();
        if (iface.getAccessParams() != null) {
            for (Map.Entry e : iface.getAccessParams().entrySet()) {
                accessParams.put(DatasourceFunctions.asSqlValue((String)e.getKey()), DatasourceFunctions.asSqlValue((String)e.getValue()));
            }
        }
        params.put("accessParams", accessParams);
        HashMap<String, String> extraFields = new HashMap<String, String>();
        if (iface.getExtraFields() != null) {
            for (Map.Entry e : iface.getExtraFields().entrySet()) {
                extraFields.put(DatasourceFunctions.asSqlValue((String)e.getKey()), DatasourceFunctions.asSqlValue((String)e.getValue()));
            }
        }
        params.put("extraFields", extraFields);
        return this.datasourceManagerClients.updateSQL(dsId, "insertInterface.sql.st", params, false, true);
    }

    public boolean deleteInterface(String dsId, String ifcId) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("datasource", DatasourceFunctions.asSqlValue(dsId));
        params.put("id", DatasourceFunctions.asSqlValue(ifcId));
        return this.datasourceManagerClients.updateSQL(dsId, "deleteInterface.sql.st", params, false, true);
    }

    public boolean updateExtraField(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        return this.updateApiCollectionsRow(dsId, ifaceId, field, value, preserveOriginal, false);
    }

    public boolean updateAccessParam(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        return this.updateApiCollectionsRow(dsId, ifaceId, field, value, preserveOriginal, true);
    }

    private boolean updateApiCollectionsRow(String dsId, String ifaceId, String field, String value, boolean preserveOriginal, boolean accessParam) throws DatasourceManagerServiceException {
        String openaireDsId = this.datasourceManagerClients.findDatasourceId(dsId);
        HashMap params = Maps.newHashMap();
        params.put("dsId", DatasourceFunctions.asSqlValue(openaireDsId));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("field", DatasourceFunctions.asSqlValue(field));
        params.put("accessParam", accessParam);
        if (value != null) {
            params.put("value", DatasourceFunctions.asSqlValue(value));
        }
        if (this.datasourceManagerClients.isDefinedParam(ifaceId, field)) {
            params.put("update", 1);
        }
        if (preserveOriginal) {
            params.put("preserveOriginal", 1);
        }
        return this.datasourceManagerClients.updateSQL(openaireDsId, "updateApiCollectionsRow.sql.st", params, false, true);
    }

    public boolean deleteAccessParamOrExtraField(String dsId, String ifaceId, String field) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("field", DatasourceFunctions.asSqlValue(field));
        return this.datasourceManagerClients.updateSQL(dsId, "deleteApiCollectionsRow.sql.st", params, false, true);
    }

    public boolean updateSQL(String dsId, String sql, boolean delete) throws DatasourceManagerServiceException {
        return this.datasourceManagerClients.updateSQL(dsId, sql, delete, true);
    }

    public Date findNextScheduledExecution(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        return this.datasourceManagerClients.findNextScheduledExecution(dsId, ifaceId);
    }

    public boolean bulkUpdateApiExtraFields(String repoId, String ifaceId, Map<String, String> fields) throws DatasourceManagerServiceException {
        return this.performUpdate(repoId, ifaceId, fields, false);
    }

    public boolean bulkUpdateApiAccessParams(String repoId, String ifaceId, Map<String, String> params) throws DatasourceManagerServiceException {
        return this.performUpdate(repoId, ifaceId, params, true);
    }

    private boolean performUpdate(String repoId, String ifaceId, Map<String, String> params, boolean accessParam) throws DatasourceManagerServiceException {
        String dsId = this.datasourceManagerClients.findDatasourceId(repoId);
        if (!accessParam) {
            this.deleteOldExtraFields(dsId, ifaceId);
        }
        for (Map.Entry<String, String> e : params.entrySet()) {
            this.performSingleUpdate(dsId, ifaceId, e.getKey(), e.getValue(), accessParam);
        }
        this.datasourceManagerClients.regenerateProfile(dsId);
        return true;
    }

    private boolean deleteOldExtraFields(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        return this.datasourceManagerClients.updateSQL(dsId, "deleteOldExtraFields.sql.st", params, false, false);
    }

    private boolean performSingleUpdate(String dsId, String ifaceId, String field, String value, boolean accessParam) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("field", DatasourceFunctions.asSqlValue(field));
        params.put("accessParam", accessParam);
        if (value != null) {
            params.put("value", DatasourceFunctions.asSqlValue(value));
        }
        if (accessParam && this.datasourceManagerClients.isDefinedParam(ifaceId, field)) {
            params.put("update", 1);
            params.put("preserveOriginal", 1);
        }
        return this.datasourceManagerClients.updateSQL(dsId, "updateApiCollectionsRow.sql.st", params, false, false);
    }

    public DatasourceManagerClients getDatasourceManagerClients() {
        return this.datasourceManagerClients;
    }

    @Required
    public void setDatasourceManagerClients(DatasourceManagerClients datasourceManagerClients) {
        this.datasourceManagerClients = datasourceManagerClients;
    }

    public boolean overrideCompliance(String repoId, String ifaceId, String compliance) throws DatasourceManagerServiceException {
        String dsId = this.datasourceManagerClients.findDatasourceId(repoId);
        HashMap params = Maps.newHashMap();
        params.put("dsId", DatasourceFunctions.asSqlValue(dsId));
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("field", DatasourceFunctions.asSqlValue("overriding_compliance"));
        if (StringUtils.isEmpty((String)compliance)) {
            params.put("delete", true);
            log.debug((Object)"Removing compliance");
        } else {
            params.put("value", DatasourceFunctions.asSqlValue(compliance));
            if (this.datasourceManagerClients.isDefinedParam(ifaceId, "overriding_compliance")) {
                params.put("update", true);
                log.debug((Object)("Updating compliance: " + compliance));
            } else {
                params.put("insert", true);
                log.debug((Object)("Adding compliance: " + compliance));
            }
        }
        return this.datasourceManagerClients.updateSQL(dsId, "overrideCompliance.sql.st", params, false, true);
    }

    public List<BrowsableField> listBrowsableFields() throws DatasourceManagerServiceException {
        return Lists.transform(this.getBrowsableFields(), (Function)new Function<DbBrowsableField, BrowsableField>(){

            public BrowsableField apply(DbBrowsableField f) {
                return new BrowsableField(f.getId(), f.getLabel());
            }
        });
    }

    public List<BrowseTerm> browseField(String f) throws DatasourceManagerServiceException {
        ArrayList list = Lists.newArrayList();
        try {
            DbBrowsableField field = this.findBrowseField(f);
            if (field != null) {
                SAXReader reader = new SAXReader();
                for (String s : this.datasourceManagerClients.searchSQL(field.getSql())) {
                    Document doc = reader.read((Reader)new StringReader(s));
                    String id = doc.valueOf("/ROW/FIELD[@name='id']");
                    String name = doc.valueOf("/ROW/FIELD[@name='name']");
                    int value = NumberUtils.toInt((String)doc.valueOf("/ROW/FIELD[@name='count']"), (int)0);
                    if (!StringUtils.isNotEmpty((String)id)) continue;
                    list.add(new BrowseTerm(id, name, value));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error browsing field " + f), (Throwable)e);
        }
        return list;
    }

    public List<SearchInterfacesEntry> searchInterface(String field, String value) throws DatasourceManagerServiceException {
        try {
            DbBrowsableField f;
            HashMap params = Maps.newHashMap();
            params.put("value", value);
            if (!field.equalsIgnoreCase("__search__")) {
                params.put("field", field);
            }
            if ((f = this.findBrowseField(field)) == null || f.isText()) {
                params.put("delimeter", "'");
            }
            final SAXReader reader = new SAXReader();
            Iterable<String> iter = this.datasourceManagerClients.searchSQL("searchRepoInterfaces.sql.st", params);
            return Lists.newArrayList((Iterable)Iterables.transform(iter, (Function)new Function<String, SearchInterfacesEntry>(){

                public SearchInterfacesEntry apply(String s) {
                    SearchInterfacesEntry iface = new SearchInterfacesEntry();
                    try {
                        Document doc = reader.read((Reader)new StringReader(s));
                        String country = doc.valueOf("/ROW/FIELD[@name='country']");
                        iface.setRepoId(doc.valueOf("/ROW/FIELD[@name='repoid']"));
                        iface.setRepoCountry(StringUtils.isEmpty((String)country) ? "-" : country.toUpperCase());
                        iface.setRepoName(StringEscapeUtils.unescapeXml((String)doc.valueOf("/ROW/FIELD[@name='reponame']")));
                        iface.setRepoPrefix(doc.valueOf("/ROW/FIELD[@name='repoprefix']"));
                        iface.setId(doc.valueOf("/ROW/FIELD[@name='id']"));
                        iface.setActive(Boolean.valueOf(doc.valueOf("/ROW/FIELD[@name='active']")).booleanValue());
                        iface.setProtocol(doc.valueOf("/ROW/FIELD[@name='protocol']"));
                        iface.setCompliance(doc.valueOf("/ROW/FIELD[@name='compliance']"));
                        iface.setAggrDate(doc.valueOf("/ROW/FIELD[@name='aggrdate']"));
                        iface.setAggrTotal(NumberUtils.toInt((String)doc.valueOf("/ROW/FIELD[@name='aggrtotal']"), (int)0));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    return iface;
                }
            }));
        }
        catch (Exception e) {
            log.error((Object)("Error searching field " + field + " - value: " + value), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private DbBrowsableField findBrowseField(String id) {
        for (DbBrowsableField f : this.getBrowsableFields()) {
            if (!f.getId().equals(id)) continue;
            return f;
        }
        return null;
    }

    public List<RepositoryMapEntry> getRepositoryMap() throws DatasourceManagerServiceException {
        final SAXReader reader = new SAXReader();
        try {
            Iterable<String> iter = this.datasourceManagerClients.searchSQL("findReposMap.sql.st", null);
            return Lists.newArrayList((Iterable)Iterables.transform(iter, (Function)new Function<String, RepositoryMapEntry>(){

                public RepositoryMapEntry apply(String s) {
                    RepositoryMapEntry r = new RepositoryMapEntry();
                    try {
                        Document doc = reader.read((Reader)new StringReader(s));
                        r.setId(doc.valueOf("/ROW/FIELD[@name='id']"));
                        r.setName(StringEscapeUtils.unescapeXml((String)doc.valueOf("/ROW/FIELD[@name='name']")));
                        r.setLat(NumberUtils.toFloat((String)doc.valueOf("/ROW/FIELD[@name='lat']"), (float)0.0f));
                        r.setLng(NumberUtils.toFloat((String)doc.valueOf("/ROW/FIELD[@name='lng']"), (float)0.0f));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    return r;
                }
            }));
        }
        catch (Exception e) {
            log.error((Object)"Error obtaing repo map entries", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<SimpleDatasourceDesc> simpleListDatasourcesByType(String type) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("type", type);
        ArrayList list = Lists.newArrayList();
        try {
            SAXReader reader = new SAXReader();
            for (String s : this.datasourceManagerClients.searchSQL("simpleFindRepos.sql.st", params)) {
                Document doc = reader.read((Reader)new StringReader(s));
                SimpleDatasourceDesc r = new SimpleDatasourceDesc();
                r.setId(doc.valueOf("/ROW/FIELD[@name='id']"));
                r.setOrigId(doc.valueOf("/ROW/FIELD[@name='id']"));
                r.setName(StringEscapeUtils.unescapeXml((String)doc.valueOf("/ROW/FIELD[@name='name']")));
                for (Object o : doc.selectNodes("/ROW/FIELD[@name='apis']/ITEM")) {
                    r.getApis().add(((Node)o).getText());
                }
                r.setValid(true);
                r.setTypology(type);
                list.add(r);
            }
            Collections.sort(list);
        }
        catch (Exception e) {
            log.error((Object)"Error listing repos", (Throwable)e);
        }
        return list;
    }

    public List<DbBrowsableField> getBrowsableFields() {
        return this.browsableFields;
    }

    @Required
    public void setBrowsableFields(List<DbBrowsableField> browsableFields) {
        this.browsableFields = browsableFields;
    }
}

