/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.datasources.DatasourceFunctions;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DatasourceManagerClients {
    private static final Resource xslt = new ClassPathResource("/eu/dnetlib/enabling/datasources/repo_2_is.xslt");
    private static final String REPOSITORY_SERVICE_RESOURCE_TYPE = "RepositoryServiceResourceType";
    private static final Log log = LogFactory.getLog(DatasourceManagerClients.class);
    private static final String TMPLS_BASEDIR = "/eu/dnetlib/enabling/datasources/";
    private String db;
    private UniqueServiceLocator serviceLocator;
    private ResultSetClientFactory resultSetClientFactory;

    public String findDatasourceId(String profileId) throws DatasourceManagerServiceException {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + profileId + "']//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value/text()");
        }
        catch (Exception e) {
            log.error((Object)("Error finding dsId of profile " + profileId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error finding dsId of profile " + profileId, (Throwable)e);
        }
    }

    public String getDatasourceProfile(String dsId) throws DatasourceManagerServiceException {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')/*[.//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value/text() = '" + dsId + "']");
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean deleteProfile(String dsId) throws DatasourceManagerServiceException {
        try {
            SAXReader reader = new SAXReader();
            String profile = this.getDatasourceProfile(dsId);
            if (profile != null) {
                Document docOld = reader.read((Reader)new StringReader(profile));
                String profId = docOld.valueOf("//RESOURCE_IDENTIFIER/@value");
                ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).deleteProfile(profId);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error deleting profile", (Throwable)e);
            throw new DatasourceManagerServiceException("Error deleting profile", (Throwable)e);
        }
    }

    public boolean regenerateProfile(String dsId) throws DatasourceManagerServiceException {
        try {
            SAXReader reader = new SAXReader();
            List<String> list = this.getTransformedDatasourcesByCondition("ds.id= '" + dsId + "'", (UnaryFunction<String, String>)new ApplyXslt(xslt));
            if (list.size() != 1) {
                throw new DatasourceManagerServiceException("Illegal number of datasource with id " + dsId + ", size: " + list.size());
            }
            Document doc = reader.read((Reader)new StringReader(list.get(0)));
            ISRegistryService registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
            String profile = this.getDatasourceProfile(dsId);
            if (profile != null) {
                Document docOld = reader.read((Reader)new StringReader(profile));
                String profId = docOld.valueOf("//RESOURCE_IDENTIFIER/@value");
                doc.selectSingleNode("//RESOURCE_IDENTIFIER/@value").setText(profId);
                registry.updateProfile(profId, doc.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
                log.info((Object)("Profile " + profId + " UPDATED for ds " + dsId));
            } else {
                String profId = registry.registerProfile(doc.asXML());
                log.info((Object)("Valid Profile " + profId + " REGISTERED for ds " + dsId));
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Error saving profile, id: " + dsId), (Throwable)e);
            throw new DatasourceManagerServiceException("Error regenerating profile", (Throwable)e);
        }
    }

    public Iterable<String> searchSQL(String sql) throws DatabaseException {
        W3CEndpointReference epr = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.getDb(), sql);
        return this.resultSetClientFactory.getClient(epr);
    }

    public boolean updateSQL(String dsId, String sql, boolean delete, boolean updateprofile) throws DatasourceManagerServiceException {
        log.debug((Object)("Executing query SQL: " + sql));
        try {
            ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).updateSQL(this.getDb(), sql);
        }
        catch (DatabaseException e) {
            throw new DatasourceManagerServiceException((Throwable)e);
        }
        if (updateprofile) {
            if (delete) {
                return this.deleteProfile(dsId);
            }
            return this.regenerateProfile(dsId);
        }
        return false;
    }

    public boolean updateSQL(String dsId, String sqlTemplate, Map<String, Object> params, boolean delete, boolean updateProfile) throws DatasourceManagerServiceException {
        this.verifyParams(params.values());
        this.verifyParams(params.keySet().toArray());
        try {
            ClassPathResource resource = new ClassPathResource(TMPLS_BASEDIR + sqlTemplate);
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)resource.getInputStream()));
            st.setAttributes(params);
            return this.updateSQL(dsId, st.toString(), delete, updateProfile);
        }
        catch (Exception e) {
            log.error((Object)"Error in updateSQL", (Throwable)e);
            throw new DatasourceManagerServiceException("Error in updateSQL", (Throwable)e);
        }
    }

    public List<DatasourceDesc> getDatasourcesByCondition(String condition) throws DatasourceManagerServiceException {
        SAXReader reader = new SAXReader();
        ArrayList list = Lists.newArrayList();
        try {
            for (String s : this.getXmlDatasourcesByCondition(condition)) {
                Document doc = reader.read((Reader)new StringReader(s));
                list.add(DatasourceFunctions.xmlToDatasourceDesc(doc));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining datasources from db", (Throwable)e);
            throw new DatasourceManagerServiceException("Error obtaining datasources from db", (Throwable)e);
        }
        return list;
    }

    private void verifyParams(Object ... params) throws DatasourceManagerServiceException {
        Pattern pattern = Pattern.compile("\\n");
        for (Object p : params) {
            log.debug((Object)("TESTING SQL PARAM:" + p));
            if (p == null || p.toString().isEmpty()) {
                log.error((Object)"Parameter null or empty");
                throw new DatasourceManagerServiceException("Parameter null or empty");
            }
            if (pattern.matcher(p.toString()).matches()) {
                log.error((Object)("Parameter [" + p + "] contains an invalid character"));
                throw new DatasourceManagerServiceException("Parameter [" + p + "] contains an invalid character");
            }
            log.debug((Object)"TEST OK");
        }
    }

    private List<String> getTransformedDatasourcesByCondition(String condition, UnaryFunction<String, String> function) throws DatasourceManagerServiceException {
        ArrayList list = Lists.newArrayList();
        try {
            for (String s : this.getXmlDatasourcesByCondition(condition)) {
                list.add(function.evaluate((Object)s));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining datasources from db", (Throwable)e);
            throw new DatasourceManagerServiceException("Error obtaining datasources from db", (Throwable)e);
        }
        return list;
    }

    private Iterable<String> getXmlDatasourcesByCondition(String condition) throws DatasourceManagerServiceException {
        try {
            HashMap params = Maps.newHashMap();
            if (condition != null && !condition.trim().isEmpty()) {
                params.put("condition", condition);
            }
            return this.searchSQL("getDatasources.sql.st", params);
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining datasources from db", (Throwable)e);
            throw new DatasourceManagerServiceException("Error obtaining datasources from db", (Throwable)e);
        }
    }

    public Iterable<String> searchSQL(String sqlTemplate, Map<String, Object> params) throws DatasourceManagerServiceException {
        try {
            ClassPathResource resource = new ClassPathResource(TMPLS_BASEDIR + sqlTemplate);
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)resource.getInputStream()));
            if (params != null) {
                st.setAttributes(params);
            }
            String sql = st.toString();
            log.debug((Object)("Executing SQL: " + sql));
            return this.searchSQL(sql);
        }
        catch (Exception e) {
            log.error((Object)"Error executing sql", (Throwable)e);
            throw new DatasourceManagerServiceException("Error obtaining datasources from db", (Throwable)e);
        }
    }

    public boolean isDefinedParam(String ifaceId, String field) throws DatasourceManagerServiceException {
        HashMap params = Maps.newHashMap();
        params.put("ifaceId", DatasourceFunctions.asSqlValue(ifaceId));
        params.put("field", DatasourceFunctions.asSqlValue(field));
        ArrayList list = Lists.newArrayList(this.searchSQL("searchApiCollectionParam.sql.st", params));
        return !list.isEmpty();
    }

    public Date findNextScheduledExecution(String dsId, String ifaceId) throws DatasourceManagerServiceException {
        String xquery = "/*[.//DATAPROVIDER/@interface='" + ifaceId + "' and .//SCHEDULING/@enabled='true']//CRON/text()";
        try {
            String cronExpression = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
            CronExpression cron = new CronExpression(cronExpression);
            return cron.getNextValidTimeAfter(new Date());
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            log.error((Object)("Error in xquery: " + xquery), (Throwable)e);
            throw new DatasourceManagerServiceException("Error in xquery: " + xquery, (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)"Error parsing cron expression", (Throwable)e);
            throw new DatasourceManagerServiceException("Error parsing cron expression", (Throwable)e);
        }
    }

    public String getDb() {
        return this.db;
    }

    @Required
    public void setDb(String db) {
        this.db = db;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

