/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.enabling.datasources.DatasourceParams;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DatasourceFunctions {
    private static final Log log = LogFactory.getLog(DatasourceFunctions.class);
    private static Resource ifaceTemplate = new ClassPathResource("/eu/dnetlib/enabling/datasources/repo_interface.st");

    public static String buildInterface(String infopackage) {
        IfaceDesc iface = DatasourceFunctions.generateIfaceDesc(infopackage);
        if (iface != null) {
            StringTemplate i = DatasourceFunctions.getTemplate(ifaceTemplate);
            i.setAttribute("ifc", (Object)iface);
            return i.toString();
        }
        return "";
    }

    public static IfaceDesc generateIfaceDesc(String infopackage) {
        if (infopackage == null || infopackage.trim().isEmpty()) {
            return null;
        }
        IfaceDesc iface = new IfaceDesc();
        iface.setId(DatasourceFunctions.getValueBetween(infopackage, null, "<==1==>"));
        iface.setTypology(DatasourceFunctions.getValueBetween(infopackage, "<==1==>", "<==2==>"));
        iface.setCompliance(DatasourceFunctions.getValueBetween(infopackage, "<==2==>", "<==3==>"));
        iface.setContentDescription(DatasourceFunctions.getValueBetween(infopackage, "<==3==>", "<==4==>"));
        iface.setAccessProtocol(DatasourceFunctions.getValueBetween(infopackage, "<==4==>", "<==5==>"));
        iface.setActive(Boolean.parseBoolean(DatasourceFunctions.getValueBetween(infopackage, "<==5==>", "<==6==>")));
        iface.setRemovable(Boolean.parseBoolean(DatasourceFunctions.getValueBetween(infopackage, "<==6==>", "<==7==>")));
        HashMap accessParams = Maps.newHashMap();
        HashMap extraParams = Maps.newHashMap();
        for (String param : DatasourceFunctions.parseParams(DatasourceFunctions.getValueBetween(infopackage, "<==7==>", null))) {
            String[] arr = param.split("###");
            if (arr.length == 3) {
                String paramValue;
                boolean accessParam = Boolean.parseBoolean(arr[0].trim());
                String paramName = arr[1].trim();
                String string = paramValue = arr.length > 2 ? arr[2].trim() : "";
                if (accessParam) {
                    if (paramName.equals(DatasourceParams.baseUrl.toString())) {
                        iface.setBaseUrl(paramValue);
                        continue;
                    }
                    accessParams.put(paramName, paramValue);
                    continue;
                }
                extraParams.put(paramName, paramValue);
                continue;
            }
            log.debug((Object)"Invalid Datasource Parameter");
        }
        iface.setAccessParams((Map)accessParams);
        iface.setExtraFields((Map)extraParams);
        return iface;
    }

    private static String getValueBetween(String s, String pre, String post) {
        if (pre == null && post == null) {
            return StringEscapeUtils.escapeXml((String)s);
        }
        if (pre == null) {
            return StringEscapeUtils.escapeXml((String)StringUtils.substringBefore((String)s, (String)post));
        }
        if (post == null) {
            return StringEscapeUtils.escapeXml((String)StringUtils.substringAfter((String)s, (String)pre));
        }
        return StringEscapeUtils.escapeXml((String)StringUtils.substringBetween((String)s, (String)pre, (String)post));
    }

    private static Iterable<String> parseParams(String s) {
        return Splitter.on((String)"@@@").omitEmptyStrings().trimResults().split((CharSequence)s);
    }

    private static StringTemplate getTemplate(Resource res) {
        try {
            return new StringTemplate(IOUtils.toString((InputStream)res.getInputStream()));
        }
        catch (IOException e) {
            log.error((Object)"unable to get template", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String asSqlValue(String s) {
        return s == null ? "NULL" : "'" + StringEscapeUtils.escapeSql((String)s) + "'";
    }

    public static String asSqlValue(Boolean b) {
        return b == null ? "NULL" : b.toString();
    }

    private static String asSqlValue(Double d) {
        return d == null ? "NULL" : d.toString();
    }

    private static Object asSqlValue(java.util.Date date) {
        if (date == null) {
            return "NULL";
        }
        long millis = date.getTime();
        Date sqlDate = new Date(millis);
        return "'" + sqlDate.toString() + "'";
    }

    public static boolean verifyCompliance(Document doc) {
        for (Object o : doc.selectNodes("//INTERFACE")) {
            String compliance2;
            String compliance = ((Node)o).valueOf("./INTERFACE_EXTRA_FIELD[@name='overriding_compliance']");
            if (!(!StringUtils.isEmpty((String)compliance) ? !"unknown".equalsIgnoreCase(compliance) && !"notCompatible".equalsIgnoreCase(compliance) : !"unknown".equalsIgnoreCase(compliance2 = ((Node)o).valueOf("@compliance")) && !"notCompatible".equalsIgnoreCase(compliance2))) continue;
            return true;
        }
        return false;
    }

    public static DatasourceDesc xmlToDatasourceDesc(Document doc) throws DatasourceManagerServiceException {
        DatasourceDesc ds = new DatasourceDesc();
        ds.setId(DatasourceFunctions.findValue(doc, "id", String.class));
        ds.setOfficialName(DatasourceFunctions.findValue(doc, "officialname", String.class));
        ds.setEnglishName(DatasourceFunctions.findValue(doc, "englishname", String.class));
        ds.setWebsiteUrl(DatasourceFunctions.findValue(doc, "websiteurl", String.class));
        ds.setLogoUrl(DatasourceFunctions.findValue(doc, "logourl", String.class));
        ds.setCountryCode(DatasourceFunctions.findValue(doc, "countrycode", String.class));
        ds.setCountryName(DatasourceFunctions.findValue(doc, "countryname", String.class));
        ds.setOrganization(DatasourceFunctions.findValue(doc, "organization", String.class));
        ds.setContactEmail(DatasourceFunctions.findValue(doc, "contactemail", String.class));
        ds.setLatitude(DatasourceFunctions.findValue(doc, "latitude", Double.class));
        ds.setLongitude(DatasourceFunctions.findValue(doc, "longitude", Double.class));
        ds.setTimezone(DatasourceFunctions.findValue(doc, "timezone", Double.class));
        ds.setNamespacePrefix(DatasourceFunctions.findValue(doc, "namespaceprefix", String.class));
        ds.setOdNumberOfItems(DatasourceFunctions.findValue(doc, "od_numberofitems", String.class));
        ds.setOdNumberOfItemsDate(DatasourceFunctions.findValue(doc, "od_numberofitemsdate", String.class));
        ds.setOdPolicies(DatasourceFunctions.findValue(doc, "od_policies", String.class));
        ds.setOdLanguages(DatasourceFunctions.findValue(doc, "od_languages", String.class));
        ds.setOdContentTypes(DatasourceFunctions.findValue(doc, "od_contenttypes", String.class));
        ds.setCollectedFrom(DatasourceFunctions.findValue(doc, "collectedfrom", String.class));
        ds.setInferred(DatasourceFunctions.findValue(doc, "inferred", Boolean.class));
        ds.setDeletedByInference(DatasourceFunctions.findValue(doc, "deletedbyinference", Boolean.class));
        ds.setTrust(DatasourceFunctions.findValue(doc, "trust", Double.class));
        ds.setInferenceProvenance(DatasourceFunctions.findValue(doc, "inferenceprovenance", String.class));
        ds.setDateOfValidation(DatasourceFunctions.findValue(doc, "dateofvalidation", java.util.Date.class));
        ds.setRegisteredBy(DatasourceFunctions.findValue(doc, "registeredby", String.class));
        ds.setDatasourceClass(DatasourceFunctions.findValue(doc, "datasourceclass", String.class));
        ds.setProvenanceActionClass(DatasourceFunctions.findValue(doc, "provenanceactionclass", String.class));
        ds.setDateOfCollection(DatasourceFunctions.findValue(doc, "dateofcollection", java.util.Date.class));
        ds.setTypology(DatasourceFunctions.findValue(doc, "typology", String.class));
        ds.setActivationId(DatasourceFunctions.findValue(doc, "activationid", String.class));
        ds.setMergehomonyms(DatasourceFunctions.findValue(doc, "mergehomonyms", Boolean.class));
        ds.setDescription(DatasourceFunctions.findValue(doc, "description", String.class));
        ds.setReleaseStartDate(DatasourceFunctions.findValue(doc, "releasestartdate", java.util.Date.class));
        ds.setReleaseEndDate(DatasourceFunctions.findValue(doc, "releaseenddate", java.util.Date.class));
        ds.setMissionStatementUrl(DatasourceFunctions.findValue(doc, "missionstatementurl", String.class));
        ds.setDataProvider(DatasourceFunctions.findValue(doc, "dataprovider", Boolean.class));
        ds.setServiceProvider(DatasourceFunctions.findValue(doc, "serviceprovider", Boolean.class));
        ds.setDatabaseAccessType(DatasourceFunctions.findValue(doc, "databaseaccesstype", String.class));
        ds.setDataUploadType(DatasourceFunctions.findValue(doc, "datauploadtype", String.class));
        ds.setDatabaseAccessRestriction(DatasourceFunctions.findValue(doc, "databaseaccessrestriction", String.class));
        ds.setDataUploadRestriction(DatasourceFunctions.findValue(doc, "datauploadrestriction", String.class));
        ds.setVersioning(DatasourceFunctions.findValue(doc, "versioning", Boolean.class));
        ds.setCitationGuidelineUrl(DatasourceFunctions.findValue(doc, "citationguidelineurl", String.class));
        ds.setQualityManagementKind(DatasourceFunctions.findValue(doc, "qualitymanagementkind", String.class));
        ds.setPidSystems(DatasourceFunctions.findValue(doc, "pidsystems", String.class));
        ds.setCertificates(DatasourceFunctions.findValue(doc, "certificates", String.class));
        ds.setAggregator(DatasourceFunctions.findValue(doc, "aggregator", String.class));
        ds.setIssn(DatasourceFunctions.findValue(doc, "issn", String.class));
        ds.setEissn(DatasourceFunctions.findValue(doc, "eissn", String.class));
        ds.setLissn(DatasourceFunctions.findValue(doc, "lissn", String.class));
        ds.setInterfaces(DatasourceFunctions.findValue(doc, "accessinfopackage", List.class));
        return ds;
    }

    private static <T> T findValue(Document doc, String elem, Class<T> clazz) throws DatasourceManagerServiceException {
        if (clazz == List.class) {
            if (elem.equalsIgnoreCase("accessinfopackage")) {
                ArrayList ifaces = Lists.newArrayList();
                for (Object o : doc.selectNodes("//FIELD[@name='accessinfopackage']/ITEM")) {
                    IfaceDesc ifaceDesc = DatasourceFunctions.generateIfaceDesc(((Node)o).getText());
                    if (ifaceDesc == null) continue;
                    ifaces.add(ifaceDesc);
                }
                return (T)ifaces;
            }
            throw new DatasourceManagerServiceException("Invalid List element " + elem);
        }
        String val = doc.valueOf("//FIELD[@name='" + elem + "' and not(@isNull='true')]");
        if (clazz == String.class) {
            return (T)val;
        }
        if (val == null || val.isEmpty()) {
            return null;
        }
        if (clazz == Boolean.class) {
            return (T)new Boolean(val);
        }
        if (clazz == Double.class) {
            return (T)new Double(val);
        }
        if (clazz == java.util.Date.class) {
            try {
                return (T)new SimpleDateFormat("yyyy-MM-dd").parse(val);
            }
            catch (ParseException e) {
                throw new DatasourceManagerServiceException("Invalid date: " + val);
            }
        }
        throw new DatasourceManagerServiceException("Invalid type " + clazz + " for element " + elem);
    }

    public static Map<String, Object> asMapOfSqlValues(DatasourceDesc ds) {
        HashMap map = Maps.newHashMap();
        map.put("id", DatasourceFunctions.asSqlValue(ds.getId()));
        map.put("officialName", DatasourceFunctions.asSqlValue(ds.getOfficialName()));
        map.put("englishName", DatasourceFunctions.asSqlValue(ds.getEnglishName()));
        map.put("websiteUrl", DatasourceFunctions.asSqlValue(ds.getWebsiteUrl()));
        map.put("logoUrl", DatasourceFunctions.asSqlValue(ds.getLogoUrl()));
        map.put("countryCode", DatasourceFunctions.asSqlValue(ds.getCountryCode()));
        map.put("countryName", DatasourceFunctions.asSqlValue(ds.getCountryName()));
        map.put("organization", DatasourceFunctions.asSqlValue(ds.getOrganization()));
        map.put("contactEmail", DatasourceFunctions.asSqlValue(ds.getContactEmail()));
        map.put("latitude", DatasourceFunctions.asSqlValue(ds.getLatitude()));
        map.put("longitude", DatasourceFunctions.asSqlValue(ds.getLongitude()));
        map.put("timezone", DatasourceFunctions.asSqlValue(ds.getTimezone()));
        map.put("namespacePrefix", DatasourceFunctions.asSqlValue(ds.getNamespacePrefix()));
        map.put("odNumberOfItems", DatasourceFunctions.asSqlValue(ds.getOdNumberOfItems()));
        map.put("odNumberOfItemsDate", DatasourceFunctions.asSqlValue(ds.getOdNumberOfItemsDate()));
        map.put("odPolicies", DatasourceFunctions.asSqlValue(ds.getOdPolicies()));
        map.put("odLanguages", DatasourceFunctions.asSqlValue(ds.getOdLanguages()));
        map.put("odContentTypes", DatasourceFunctions.asSqlValue(ds.getOdContentTypes()));
        map.put("collectedFrom", DatasourceFunctions.asSqlValue(ds.getCollectedFrom()));
        map.put("inferred", DatasourceFunctions.asSqlValue(ds.isInferred()));
        map.put("deletedByInference", DatasourceFunctions.asSqlValue(ds.isDeletedByInference()));
        map.put("trust", DatasourceFunctions.asSqlValue(ds.getTrust()));
        map.put("inferenceProvenance", DatasourceFunctions.asSqlValue(ds.getInferenceProvenance()));
        map.put("dateOfValidation", DatasourceFunctions.asSqlValue(ds.getDateOfValidation()));
        map.put("registeredBy", DatasourceFunctions.asSqlValue(ds.getRegisteredBy()));
        map.put("datasourceClass", DatasourceFunctions.asSqlValue(ds.getDatasourceClass()));
        map.put("provenanceActionClass", DatasourceFunctions.asSqlValue(ds.getProvenanceActionClass()));
        map.put("dateOfCollection", DatasourceFunctions.asSqlValue(ds.getDateOfCollection()));
        map.put("typology", DatasourceFunctions.asSqlValue(ds.getTypology()));
        map.put("activationId", DatasourceFunctions.asSqlValue(ds.getActivationId()));
        map.put("mergehomonyms", DatasourceFunctions.asSqlValue(ds.isMergehomonyms()));
        map.put("description", DatasourceFunctions.asSqlValue(ds.getDescription()));
        map.put("releaseStartDate", DatasourceFunctions.asSqlValue(ds.getReleaseStartDate()));
        map.put("releaseEndDate", DatasourceFunctions.asSqlValue(ds.getReleaseEndDate()));
        map.put("missionStatementUrl", DatasourceFunctions.asSqlValue(ds.getMissionStatementUrl()));
        map.put("dataProvider", DatasourceFunctions.asSqlValue(ds.isDataProvider()));
        map.put("serviceProvider", DatasourceFunctions.asSqlValue(ds.isServiceProvider()));
        map.put("databaseAccessType", DatasourceFunctions.asSqlValue(ds.getDatabaseAccessType()));
        map.put("dataUploadType", DatasourceFunctions.asSqlValue(ds.getDataUploadType()));
        map.put("databaseAccessRestriction", DatasourceFunctions.asSqlValue(ds.getDatabaseAccessRestriction()));
        map.put("dataUploadRestriction", DatasourceFunctions.asSqlValue(ds.getDataUploadRestriction()));
        map.put("versioning", DatasourceFunctions.asSqlValue(ds.isVersioning()));
        map.put("citationGuidelineUrl", DatasourceFunctions.asSqlValue(ds.getCitationGuidelineUrl()));
        map.put("qualityManagementKind", DatasourceFunctions.asSqlValue(ds.getQualityManagementKind()));
        map.put("pidSystems", DatasourceFunctions.asSqlValue(ds.getPidSystems()));
        map.put("certificates", DatasourceFunctions.asSqlValue(ds.getCertificates()));
        map.put("aggregator", DatasourceFunctions.asSqlValue(ds.getAggregator()));
        map.put("issn", DatasourceFunctions.asSqlValue(ds.getIssn()));
        map.put("eissn", DatasourceFunctions.asSqlValue(ds.getEissn()));
        map.put("lissn", DatasourceFunctions.asSqlValue(ds.getLissn()));
        ArrayList<HashMap> ifaces = new ArrayList<HashMap>();
        if (ds.getInterfaces() != null) {
            for (IfaceDesc iface : ds.getInterfaces()) {
                if (iface.getId() == null || iface.getId().trim().isEmpty()) continue;
                HashMap mapIface = Maps.newHashMap();
                mapIface.put("id", DatasourceFunctions.asSqlValue(iface.getId()));
                mapIface.put("typology", DatasourceFunctions.asSqlValue(iface.getTypology()));
                mapIface.put("compliance", DatasourceFunctions.asSqlValue(iface.getCompliance()));
                mapIface.put("contentDescription", DatasourceFunctions.asSqlValue(iface.getContentDescription()));
                mapIface.put("accessProtocol", DatasourceFunctions.asSqlValue(iface.getAccessProtocol()));
                mapIface.put("baseUrl", DatasourceFunctions.asSqlValue(iface.getBaseUrl()));
                HashMap extraFields = Maps.newHashMap();
                if (iface.getExtraFields() != null) {
                    for (String k : iface.getExtraFields().keySet()) {
                        if (k == null || k.trim().isEmpty()) continue;
                        extraFields.put(DatasourceFunctions.asSqlValue(k), DatasourceFunctions.asSqlValue((String)iface.getExtraFields().get(k)));
                    }
                }
                mapIface.put("extraFields", extraFields);
                HashMap accessParams = Maps.newHashMap();
                if (iface.getAccessParams() != null) {
                    for (String k : iface.getAccessParams().keySet()) {
                        if (k == null || k.trim().isEmpty()) continue;
                        accessParams.put(DatasourceFunctions.asSqlValue(k), DatasourceFunctions.asSqlValue((String)iface.getAccessParams().get(k)));
                    }
                }
                mapIface.put("accessParams", accessParams);
                ifaces.add(mapIface);
            }
            map.put("interfaces", ifaces);
        }
        return map;
    }

    public static Map<String, Object> asMapOfSqlValues(Map<String, String> input) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, String> e : input.entrySet()) {
            map.put(DatasourceFunctions.asSqlValue(e.getKey()), DatasourceFunctions.asSqlValue(e.getValue()));
        }
        return map;
    }
}

